/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardDeleteByQueryAction
extends TransportShardReplicationOperationAction<ShardDeleteByQueryRequest, ShardDeleteByQueryRequest, ShardDeleteByQueryResponse> {
    @Inject
    public TransportShardDeleteByQueryAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected ShardDeleteByQueryRequest newRequestInstance() {
        return new ShardDeleteByQueryRequest();
    }

    @Override
    protected ShardDeleteByQueryRequest newReplicaRequestInstance() {
        return new ShardDeleteByQueryRequest();
    }

    @Override
    protected ShardDeleteByQueryResponse newResponseInstance() {
        return new ShardDeleteByQueryResponse();
    }

    @Override
    protected String transportAction() {
        return "deleteByQuery/shard";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state2, ShardDeleteByQueryRequest request) {
        return state2.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state2, ShardDeleteByQueryRequest request) {
        return state2.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteByQueryResponse, ShardDeleteByQueryRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        ShardDeleteByQueryRequest request = (ShardDeleteByQueryRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((ShardDeleteByQueryRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.DeleteByQuery deleteByQuery = indexShard.prepareDeleteByQuery(request.querySource(), request.filteringAliases(), request.types());
        indexShard.deleteByQuery(deleteByQuery);
        return new TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteByQueryResponse, ShardDeleteByQueryRequest>((ShardDeleteByQueryRequest)shardRequest.request, new ShardDeleteByQueryResponse(), null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        ShardDeleteByQueryRequest request = (ShardDeleteByQueryRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((ShardDeleteByQueryRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.DeleteByQuery deleteByQuery = indexShard.prepareDeleteByQuery(request.querySource(), request.filteringAliases(), request.types());
        indexShard.deleteByQuery(deleteByQuery);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, ShardDeleteByQueryRequest request) {
        GroupShardsIterator group2 = this.clusterService.operationRouting().deleteByQueryShards(this.clusterService.state(), request.index(), request.routing());
        for (ShardIterator shardIt : group2) {
            if (shardIt.shardId().id() != request.shardId()) continue;
            return shardIt;
        }
        throw new ElasticSearchIllegalStateException("No shards iterator found for shard [" + request.shardId() + "]");
    }
}

