/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.common.unit.TimeValue;

public class IndexDeleteByQueryRequest
extends IndexReplicationOperationRequest<IndexDeleteByQueryRequest> {
    private BytesReference querySource;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private Set<String> routing;
    @Nullable
    private String[] filteringAliases;

    IndexDeleteByQueryRequest(DeleteByQueryRequest request, String index2, @Nullable Set<String> routing, @Nullable String[] filteringAliases) {
        this.index = index2;
        this.timeout = request.timeout();
        this.querySource = request.querySource();
        this.types = request.types();
        this.replicationType = request.replicationType();
        this.consistencyLevel = request.consistencyLevel();
        this.routing = routing;
        this.filteringAliases = filteringAliases;
    }

    IndexDeleteByQueryRequest() {
    }

    BytesReference querySource() {
        return this.querySource;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            validationException = ValidateActions.addValidationError("querySource is missing", validationException);
        }
        return validationException;
    }

    Set<String> routing() {
        return this.routing;
    }

    String[] types() {
        return this.types;
    }

    String[] filteringAliases() {
        return this.filteringAliases;
    }

    public IndexDeleteByQueryRequest timeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        int routingSize;
        super.readFrom(in);
        this.querySource = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i2 = 0; i2 < typesSize; ++i2) {
                this.types[i2] = in.readString();
            }
        }
        if ((routingSize = in.readVInt()) > 0) {
            this.routing = new THashSet<String>(routingSize);
            for (int i3 = 0; i3 < routingSize; ++i3) {
                this.routing.add(in.readString());
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i4 = 0; i4 < aliasesSize; ++i4) {
                this.filteringAliases[i4] = in.readString();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.querySource);
        out.writeVInt(this.types.length);
        for (String type2 : this.types) {
            out.writeString(type2);
        }
        if (this.routing != null) {
            out.writeVInt(this.routing.size());
            for (String r : this.routing) {
                out.writeString(r);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias2 : this.filteringAliases) {
                out.writeString(alias2);
            }
        } else {
            out.writeVInt(0);
        }
    }
}

