/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.delete.index.IndexDeleteRequest;
import org.elasticsearch.action.delete.index.IndexDeleteResponse;
import org.elasticsearch.action.delete.index.ShardDeleteRequest;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.action.delete.index.TransportShardDeleteAction;
import org.elasticsearch.action.support.replication.TransportIndexReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndexDeleteAction
extends TransportIndexReplicationOperationAction<IndexDeleteRequest, IndexDeleteResponse, ShardDeleteRequest, ShardDeleteRequest, ShardDeleteResponse> {
    @Inject
    public TransportIndexDeleteAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, TransportShardDeleteAction deleteAction) {
        super(settings, transportService, clusterService, threadPool, deleteAction);
    }

    @Override
    protected IndexDeleteRequest newRequestInstance() {
        return new IndexDeleteRequest();
    }

    @Override
    protected IndexDeleteResponse newResponseInstance(IndexDeleteRequest request, AtomicReferenceArray shardsResponses) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<ShardDeleteResponse> responses = new ArrayList<ShardDeleteResponse>();
        for (int i2 = 0; i2 < shardsResponses.length(); ++i2) {
            if (shardsResponses.get(i2) == null) {
                ++failedShards;
                continue;
            }
            responses.add((ShardDeleteResponse)shardsResponses.get(i2));
            ++successfulShards;
        }
        return new IndexDeleteResponse(request.index(), successfulShards, failedShards, responses.toArray(new ShardDeleteResponse[responses.size()]));
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    @Override
    protected String transportAction() {
        return "indices/index/delete";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state2, IndexDeleteRequest request) {
        return state2.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state2, IndexDeleteRequest request) {
        return state2.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected GroupShardsIterator shards(IndexDeleteRequest request) {
        return this.clusterService.operationRouting().broadcastDeleteShards(this.clusterService.state(), request.index());
    }

    @Override
    protected ShardDeleteRequest newShardRequestInstance(IndexDeleteRequest request, int shardId) {
        return new ShardDeleteRequest(request, shardId);
    }
}

