/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexDeleteResponse
extends ActionResponse {
    private String index;
    private int successfulShards;
    private int failedShards;
    private ShardDeleteResponse[] deleteResponses;

    IndexDeleteResponse(String index2, int successfulShards, int failedShards, ShardDeleteResponse[] deleteResponses) {
        this.index = index2;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.deleteResponses = deleteResponses;
    }

    IndexDeleteResponse() {
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index;
    }

    public int totalShards() {
        return this.failedShards + this.successfulShards;
    }

    public int getTotalShards() {
        return this.totalShards();
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int failedShards() {
        return this.failedShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public ShardDeleteResponse[] responses() {
        return this.deleteResponses;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        this.deleteResponses = new ShardDeleteResponse[in.readVInt()];
        for (int i2 = 0; i2 < this.deleteResponses.length; ++i2) {
            this.deleteResponses[i2] = new ShardDeleteResponse();
            this.deleteResponses[i2].readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.deleteResponses.length);
        for (ShardDeleteResponse deleteResponse : this.deleteResponses) {
            deleteResponse.writeTo(out);
        }
    }
}

