/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.VersionType;

public class BulkRequest
extends ActionRequest<BulkRequest> {
    private static final int REQUEST_OVERHEAD = 50;
    final List<ActionRequest> requests = Lists.newArrayList();
    List<Object> payloads = null;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;
    private boolean refresh = false;
    private long sizeInBytes = 0L;

    public BulkRequest add(ActionRequest ... requests) {
        for (ActionRequest request : requests) {
            this.add(request, (Object)null);
        }
        return this;
    }

    public BulkRequest add(ActionRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(ActionRequest request, @Nullable Object payload) {
        if (request instanceof IndexRequest) {
            this.add((IndexRequest)request, payload);
        } else if (request instanceof DeleteRequest) {
            this.add((DeleteRequest)request, payload);
        } else {
            throw new ElasticSearchIllegalArgumentException("No support for request [" + request + "]");
        }
        return this;
    }

    public BulkRequest add(Iterable<ActionRequest> requests) {
        for (ActionRequest request : requests) {
            if (request instanceof IndexRequest) {
                this.add((IndexRequest)request);
                continue;
            }
            if (request instanceof DeleteRequest) {
                this.add((DeleteRequest)request);
                continue;
            }
            throw new ElasticSearchIllegalArgumentException("No support for request [" + request + "]");
        }
        return this;
    }

    public BulkRequest add(IndexRequest request) {
        request.beforeLocalFork();
        return this.internalAdd(request, null);
    }

    public BulkRequest add(IndexRequest request, @Nullable Object payload) {
        request.beforeLocalFork();
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(IndexRequest request, @Nullable Object payload) {
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += (long)(request.source().length() + 50);
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(DeleteRequest request, @Nullable Object payload) {
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += 50L;
        return this;
    }

    private void addPayload(Object payload) {
        if (this.payloads == null) {
            if (payload == null) {
                return;
            }
            this.payloads = new ArrayList<Object>(this.requests.size() + 10);
            for (int i2 = 1; i2 < this.requests.size(); ++i2) {
                this.payloads.add(null);
            }
        }
        this.payloads.add(payload);
    }

    public List<ActionRequest> requests() {
        return this.requests;
    }

    @Nullable
    public List<Object> payloads() {
        return this.payloads;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    public long estimatedSizeInBytes() {
        return this.sizeInBytes;
    }

    public BulkRequest add(byte[] data2, int from, int length2, boolean contentUnsafe) throws Exception {
        return this.add(data2, from, length2, contentUnsafe, null, null);
    }

    public BulkRequest add(byte[] data2, int from, int length2, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(new BytesArray(data2, from, length2), contentUnsafe, defaultIndex, defaultType);
    }

    public BulkRequest add(BytesReference data2, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(data2, contentUnsafe, defaultIndex, defaultType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkRequest add(BytesReference data2, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable Object payload) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data2);
        int from = 0;
        int length2 = data2.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data2, length2)) != -1) {
            XContentParser parser = xContent.createParser(data2.slice(from, nextMarker - from));
            try {
                from = nextMarker + 1;
                XContentParser.Token token = parser.nextToken();
                if (token == null) continue;
                assert (token == XContentParser.Token.START_OBJECT);
                token = parser.nextToken();
                assert (token == XContentParser.Token.FIELD_NAME);
                String action = parser.currentName();
                String index2 = defaultIndex;
                String type2 = defaultType;
                String id2 = null;
                String routing = null;
                String parent = null;
                String timestamp = null;
                Long ttl = null;
                String opType = null;
                long version = 0L;
                VersionType versionType = VersionType.INTERNAL;
                String percolate = null;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if ("_index".equals(currentFieldName)) {
                        index2 = parser.text();
                        continue;
                    }
                    if ("_type".equals(currentFieldName)) {
                        type2 = parser.text();
                        continue;
                    }
                    if ("_id".equals(currentFieldName)) {
                        id2 = parser.text();
                        continue;
                    }
                    if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                        routing = parser.text();
                        continue;
                    }
                    if ("_parent".equals(currentFieldName) || "parent".equals(currentFieldName)) {
                        parent = parser.text();
                        continue;
                    }
                    if ("_timestamp".equals(currentFieldName) || "timestamp".equals(currentFieldName)) {
                        timestamp = parser.text();
                        continue;
                    }
                    if ("_ttl".equals(currentFieldName) || "ttl".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                            ttl = TimeValue.parseTimeValue(parser.text(), null).millis();
                            continue;
                        }
                        ttl = parser.longValue();
                        continue;
                    }
                    if ("op_type".equals(currentFieldName) || "opType".equals(currentFieldName)) {
                        opType = parser.text();
                        continue;
                    }
                    if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                        version = parser.longValue();
                        continue;
                    }
                    if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                        versionType = VersionType.fromString(parser.text());
                        continue;
                    }
                    if (!"percolate".equals(currentFieldName) && !"_percolate".equals(currentFieldName)) continue;
                    percolate = parser.textOrNull();
                }
                if ("delete".equals(action)) {
                    this.add(new DeleteRequest(index2, type2, id2).parent(parent).version(version).versionType(versionType).routing(routing), payload);
                    continue;
                }
                nextMarker = this.findNextMarker(marker, from, data2, length2);
                if (nextMarker == -1) break;
                if ("index".equals(action)) {
                    if (opType == null) {
                        this.internalAdd(new IndexRequest(index2, type2, id2).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).source(data2.slice(from, nextMarker - from), contentUnsafe).percolate(percolate), payload);
                    } else {
                        this.internalAdd(new IndexRequest(index2, type2, id2).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create("create".equals(opType)).source(data2.slice(from, nextMarker - from), contentUnsafe).percolate(percolate), payload);
                    }
                } else if ("create".equals(action)) {
                    this.internalAdd(new IndexRequest(index2, type2, id2).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create(true).source(data2.slice(from, nextMarker - from), contentUnsafe).percolate(percolate), payload);
                }
                from = nextMarker + 1;
            }
            finally {
                parser.close();
            }
        }
        return this;
    }

    public BulkRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public BulkRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public BulkRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    private int findNextMarker(byte marker, int from, BytesReference data2, int length2) {
        for (int i2 = from; i2 < length2; ++i2) {
            if (data2.get(i2) != marker) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i2 = 0; i2 < this.requests.size(); ++i2) {
            ActionRequestValidationException ex = this.requests.get(i2).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        int size2 = in.readVInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            ShardReplicationOperationRequest request;
            byte type2 = in.readByte();
            if (type2 == 0) {
                request = new IndexRequest();
                ((IndexRequest)request).readFrom(in);
                this.requests.add(request);
                continue;
            }
            if (type2 != 1) continue;
            request = new DeleteRequest();
            ((DeleteRequest)request).readFrom(in);
            this.requests.add(request);
        }
        this.refresh = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        out.writeVInt(this.requests.size());
        for (ActionRequest request : this.requests) {
            if (request instanceof IndexRequest) {
                out.writeByte((byte)0);
            } else if (request instanceof DeleteRequest) {
                out.writeByte((byte)1);
            }
            request.writeTo(out);
        }
        out.writeBoolean(this.refresh);
    }
}

