/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class PeerRecoveryStatus {
    final Stage stage;
    final long startTime;
    final long time;
    final long indexSize;
    final long reusedIndexSize;
    final long recoveredIndexSize;
    final long recoveredTranslogOperations;

    public PeerRecoveryStatus(Stage stage, long startTime, long time, long indexSize, long reusedIndexSize, long recoveredIndexSize, long recoveredTranslogOperations) {
        this.stage = stage;
        this.startTime = startTime;
        this.time = time;
        this.indexSize = indexSize;
        this.reusedIndexSize = reusedIndexSize;
        this.recoveredIndexSize = recoveredIndexSize;
        this.recoveredTranslogOperations = recoveredTranslogOperations;
    }

    public Stage stage() {
        return this.stage;
    }

    public long startTime() {
        return this.startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TimeValue time() {
        return TimeValue.timeValueMillis(this.time);
    }

    public TimeValue getTime() {
        return this.time();
    }

    public ByteSizeValue indexSize() {
        return new ByteSizeValue(this.indexSize);
    }

    public ByteSizeValue getIndexSize() {
        return this.indexSize();
    }

    public ByteSizeValue reusedIndexSize() {
        return new ByteSizeValue(this.reusedIndexSize);
    }

    public ByteSizeValue getReusedIndexSize() {
        return this.reusedIndexSize();
    }

    public ByteSizeValue expectedRecoveredIndexSize() {
        return new ByteSizeValue(this.indexSize - this.reusedIndexSize);
    }

    public ByteSizeValue getExpectedRecoveredIndexSize() {
        return this.expectedRecoveredIndexSize();
    }

    public ByteSizeValue recoveredIndexSize() {
        return new ByteSizeValue(this.recoveredIndexSize);
    }

    public ByteSizeValue getRecoveredIndexSize() {
        return this.recoveredIndexSize();
    }

    public int indexRecoveryProgress() {
        if (this.recoveredIndexSize == 0L) {
            if (this.indexSize != 0L && this.indexSize == this.reusedIndexSize) {
                return 100;
            }
            return 0;
        }
        return (int)((double)this.recoveredIndexSize / (double)this.expectedRecoveredIndexSize().bytes() * 100.0);
    }

    public int getIndexRecoveryProgress() {
        return this.indexRecoveryProgress();
    }

    public long recoveredTranslogOperations() {
        return this.recoveredTranslogOperations;
    }

    public long getRecoveredTranslogOperations() {
        return this.recoveredTranslogOperations();
    }

    public static enum Stage {
        INIT(0),
        INDEX(1),
        TRANSLOG(2),
        FINALIZE(3),
        DONE(4);

        private final byte value;

        private Stage(byte value2) {
            this.value = value2;
        }

        public byte value() {
            return this.value;
        }

        public static Stage fromValue(byte value2) {
            if (value2 == 0) {
                return INIT;
            }
            if (value2 == 1) {
                return INDEX;
            }
            if (value2 == 2) {
                return TRANSLOG;
            }
            if (value2 == 3) {
                return FINALIZE;
            }
            if (value2 == 4) {
                return DONE;
            }
            throw new ElasticSearchIllegalArgumentException("No stage found for [" + value2 + ']');
        }
    }
}

