/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.status.GatewayRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.GatewaySnapshotStatus;
import org.elasticsearch.action.admin.indices.status.IndexShardStatus;
import org.elasticsearch.action.admin.indices.status.IndexStatus;
import org.elasticsearch.action.admin.indices.status.PeerRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;

public class IndicesStatusResponse
extends BroadcastOperationResponse
implements ToXContent {
    protected ShardStatus[] shards;
    private Map<String, IndexStatus> indicesStatus;

    IndicesStatusResponse() {
    }

    IndicesStatusResponse(ShardStatus[] shards, ClusterState clusterState, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public ShardStatus[] shards() {
        return this.shards;
    }

    public ShardStatus[] getShards() {
        return this.shards;
    }

    public ShardStatus getAt(int position) {
        return this.shards[position];
    }

    public IndexStatus index(String index2) {
        return this.indices().get(index2);
    }

    public Map<String, IndexStatus> getIndices() {
        return this.indices();
    }

    public Map<String, IndexStatus> indices() {
        if (this.indicesStatus != null) {
            return this.indicesStatus;
        }
        HashMap<String, IndexStatus> indicesStatus = Maps.newHashMap();
        HashSet<String> indices2 = Sets.newHashSet();
        for (ShardStatus shard : this.shards) {
            indices2.add(shard.index());
        }
        for (String index2 : indices2) {
            ArrayList<ShardStatus> shards = Lists.newArrayList();
            for (ShardStatus shard : this.shards) {
                if (!shard.shardRouting().index().equals(index2)) continue;
                shards.add(shard);
            }
            indicesStatus.put(index2, new IndexStatus(index2, shards.toArray(new ShardStatus[shards.size()])));
        }
        this.indicesStatus = indicesStatus;
        return indicesStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shards().length);
        for (ShardStatus status2 : this.shards()) {
            status2.writeTo(out);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shards = new ShardStatus[in.readVInt()];
        for (int i2 = 0; i2 < this.shards.length; ++i2) {
            this.shards[i2] = ShardStatus.readIndexShardStatus(in);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        return this.toXContent(builder, params2, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2, @Nullable SettingsFilter settingsFilter) throws IOException {
        builder.startObject(Fields.INDICES);
        for (IndexStatus indexStatus : this.indices().values()) {
            FlushStats flushStats;
            RefreshStats refreshStats;
            MergeStats mergeStats;
            builder.startObject(indexStatus.index(), XContentBuilder.FieldCaseConversion.NONE);
            builder.startObject(Fields.INDEX);
            if (indexStatus.storeSize() != null) {
                builder.field(Fields.PRIMARY_SIZE, indexStatus.primaryStoreSize().toString());
                builder.field(Fields.PRIMARY_SIZE_IN_BYTES, indexStatus.primaryStoreSize().bytes());
                builder.field(Fields.SIZE, indexStatus.storeSize().toString());
                builder.field(Fields.SIZE_IN_BYTES, indexStatus.storeSize().bytes());
            }
            builder.endObject();
            if (indexStatus.translogOperations() != -1L) {
                builder.startObject(Fields.TRANSLOG);
                builder.field(Fields.OPERATIONS, indexStatus.translogOperations());
                builder.endObject();
            }
            if (indexStatus.docs() != null) {
                builder.startObject(Fields.DOCS);
                builder.field(Fields.NUM_DOCS, indexStatus.docs().numDocs());
                builder.field(Fields.MAX_DOC, indexStatus.docs().maxDoc());
                builder.field(Fields.DELETED_DOCS, indexStatus.docs().deletedDocs());
                builder.endObject();
            }
            if ((mergeStats = indexStatus.mergeStats()) != null) {
                mergeStats.toXContent(builder, params2);
            }
            if ((refreshStats = indexStatus.refreshStats()) != null) {
                refreshStats.toXContent(builder, params2);
            }
            if ((flushStats = indexStatus.flushStats()) != null) {
                flushStats.toXContent(builder, params2);
            }
            builder.startObject(Fields.SHARDS);
            for (IndexShardStatus indexShardStatus : indexStatus) {
                builder.startArray(Integer.toString(indexShardStatus.shardId().id()));
                for (ShardStatus shardStatus : indexShardStatus) {
                    builder.startObject();
                    builder.startObject(Fields.ROUTING).field(Fields.STATE, (Object)shardStatus.shardRouting().state()).field(Fields.PRIMARY, shardStatus.shardRouting().primary()).field(Fields.NODE, shardStatus.shardRouting().currentNodeId()).field(Fields.RELOCATING_NODE, shardStatus.shardRouting().relocatingNodeId()).field(Fields.SHARD, shardStatus.shardRouting().shardId().id()).field(Fields.INDEX, shardStatus.shardRouting().shardId().index().name()).endObject();
                    builder.field(Fields.STATE, (Object)shardStatus.state());
                    if (shardStatus.storeSize() != null) {
                        builder.startObject(Fields.INDEX);
                        builder.field(Fields.SIZE, shardStatus.storeSize().toString());
                        builder.field(Fields.SIZE_IN_BYTES, shardStatus.storeSize().bytes());
                        builder.endObject();
                    }
                    if (shardStatus.translogId() != -1L) {
                        builder.startObject(Fields.TRANSLOG);
                        builder.field(Fields.ID, shardStatus.translogId());
                        builder.field(Fields.OPERATIONS, shardStatus.translogOperations());
                        builder.endObject();
                    }
                    if (shardStatus.docs() != null) {
                        builder.startObject(Fields.DOCS);
                        builder.field(Fields.NUM_DOCS, shardStatus.docs().numDocs());
                        builder.field(Fields.MAX_DOC, shardStatus.docs().maxDoc());
                        builder.field(Fields.DELETED_DOCS, shardStatus.docs().deletedDocs());
                        builder.endObject();
                    }
                    if ((mergeStats = shardStatus.mergeStats()) != null) {
                        mergeStats.toXContent(builder, params2);
                    }
                    if ((refreshStats = shardStatus.refreshStats()) != null) {
                        refreshStats.toXContent(builder, params2);
                    }
                    if ((flushStats = shardStatus.flushStats()) != null) {
                        flushStats.toXContent(builder, params2);
                    }
                    if (shardStatus.peerRecoveryStatus() != null) {
                        PeerRecoveryStatus peerRecoveryStatus = shardStatus.peerRecoveryStatus();
                        builder.startObject(Fields.PEER_RECOVERY);
                        builder.field(Fields.STAGE, (Object)peerRecoveryStatus.stage());
                        builder.field(Fields.START_TIME_IN_MILLIS, peerRecoveryStatus.startTime());
                        builder.field(Fields.TIME, (Object)peerRecoveryStatus.time());
                        builder.field(Fields.TIME_IN_MILLIS, peerRecoveryStatus.time().millis());
                        builder.startObject(Fields.INDEX);
                        builder.field(Fields.PROGRESS, peerRecoveryStatus.indexRecoveryProgress());
                        builder.field(Fields.SIZE, (Object)peerRecoveryStatus.indexSize());
                        builder.field(Fields.SIZE_IN_BYTES, peerRecoveryStatus.indexSize().bytes());
                        builder.field(Fields.REUSED_SIZE, (Object)peerRecoveryStatus.reusedIndexSize());
                        builder.field(Fields.REUSED_SIZE_IN_BYTES, peerRecoveryStatus.reusedIndexSize().bytes());
                        builder.field(Fields.EXPECTED_RECOVERED_SIZE, (Object)peerRecoveryStatus.expectedRecoveredIndexSize());
                        builder.field(Fields.EXPECTED_RECOVERED_SIZE_IN_BYTES, peerRecoveryStatus.expectedRecoveredIndexSize().bytes());
                        builder.field(Fields.RECOVERED_SIZE, (Object)peerRecoveryStatus.recoveredIndexSize());
                        builder.field(Fields.RECOVERED_SIZE_IN_BYTES, peerRecoveryStatus.recoveredIndexSize().bytes());
                        builder.endObject();
                        builder.startObject(Fields.TRANSLOG);
                        builder.field(Fields.RECOVERED, peerRecoveryStatus.recoveredTranslogOperations());
                        builder.endObject();
                        builder.endObject();
                    }
                    if (shardStatus.gatewayRecoveryStatus() != null) {
                        GatewayRecoveryStatus gatewayRecoveryStatus = shardStatus.gatewayRecoveryStatus();
                        builder.startObject(Fields.GATEWAY_RECOVERY);
                        builder.field(Fields.STAGE, (Object)gatewayRecoveryStatus.stage());
                        builder.field(Fields.START_TIME_IN_MILLIS, gatewayRecoveryStatus.startTime());
                        builder.field(Fields.TIME, (Object)gatewayRecoveryStatus.time());
                        builder.field(Fields.TIME_IN_MILLIS, gatewayRecoveryStatus.time().millis());
                        builder.startObject(Fields.INDEX);
                        builder.field(Fields.PROGRESS, gatewayRecoveryStatus.indexRecoveryProgress());
                        builder.field(Fields.SIZE, (Object)gatewayRecoveryStatus.indexSize());
                        builder.field(Fields.SIZE_IN_BYTES, gatewayRecoveryStatus.indexSize().bytes());
                        builder.field(Fields.REUSED_SIZE, (Object)gatewayRecoveryStatus.reusedIndexSize());
                        builder.field(Fields.REUSED_SIZE_IN_BYTES, gatewayRecoveryStatus.reusedIndexSize().bytes());
                        builder.field(Fields.EXPECTED_RECOVERED_SIZE, (Object)gatewayRecoveryStatus.expectedRecoveredIndexSize());
                        builder.field(Fields.EXPECTED_RECOVERED_SIZE_IN_BYTES, gatewayRecoveryStatus.expectedRecoveredIndexSize().bytes());
                        builder.field(Fields.RECOVERED_SIZE, (Object)gatewayRecoveryStatus.recoveredIndexSize());
                        builder.field(Fields.RECOVERED_SIZE_IN_BYTES, gatewayRecoveryStatus.recoveredIndexSize().bytes());
                        builder.endObject();
                        builder.startObject(Fields.TRANSLOG);
                        builder.field(Fields.RECOVERED, gatewayRecoveryStatus.recoveredTranslogOperations());
                        builder.endObject();
                        builder.endObject();
                    }
                    if (shardStatus.gatewaySnapshotStatus() != null) {
                        GatewaySnapshotStatus gatewaySnapshotStatus = shardStatus.gatewaySnapshotStatus();
                        builder.startObject(Fields.GATEWAY_SNAPSHOT);
                        builder.field(Fields.STAGE, (Object)gatewaySnapshotStatus.stage());
                        builder.field(Fields.START_TIME_IN_MILLIS, gatewaySnapshotStatus.startTime());
                        builder.field(Fields.TIME, (Object)gatewaySnapshotStatus.time());
                        builder.field(Fields.TIME_IN_MILLIS, gatewaySnapshotStatus.time().millis());
                        builder.startObject(Fields.INDEX);
                        builder.field(Fields.SIZE, (Object)gatewaySnapshotStatus.indexSize());
                        builder.field(Fields.SIZE_IN_BYTES, gatewaySnapshotStatus.indexSize().bytes());
                        builder.endObject();
                        builder.startObject(Fields.TRANSLOG);
                        builder.field(Fields.EXPECTED_OPERATIONS, gatewaySnapshotStatus.expectedNumberOfOperations());
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString PRIMARY_SIZE = new XContentBuilderString("primary_size");
        static final XContentBuilderString PRIMARY_SIZE_IN_BYTES = new XContentBuilderString("primary_size_in_bytes");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
        static final XContentBuilderString TRANSLOG = new XContentBuilderString("translog");
        static final XContentBuilderString OPERATIONS = new XContentBuilderString("operations");
        static final XContentBuilderString DOCS = new XContentBuilderString("docs");
        static final XContentBuilderString NUM_DOCS = new XContentBuilderString("num_docs");
        static final XContentBuilderString MAX_DOC = new XContentBuilderString("max_doc");
        static final XContentBuilderString DELETED_DOCS = new XContentBuilderString("deleted_docs");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString ROUTING = new XContentBuilderString("routing");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString NODE = new XContentBuilderString("node");
        static final XContentBuilderString RELOCATING_NODE = new XContentBuilderString("relocating_node");
        static final XContentBuilderString SHARD = new XContentBuilderString("shard");
        static final XContentBuilderString ID = new XContentBuilderString("id");
        static final XContentBuilderString PEER_RECOVERY = new XContentBuilderString("peer_recovery");
        static final XContentBuilderString STAGE = new XContentBuilderString("stage");
        static final XContentBuilderString START_TIME_IN_MILLIS = new XContentBuilderString("start_time_in_millis");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString TIME_IN_MILLIS = new XContentBuilderString("time_in_millis");
        static final XContentBuilderString PROGRESS = new XContentBuilderString("progress");
        static final XContentBuilderString REUSED_SIZE = new XContentBuilderString("reused_size");
        static final XContentBuilderString REUSED_SIZE_IN_BYTES = new XContentBuilderString("reused_size_in_bytes");
        static final XContentBuilderString EXPECTED_RECOVERED_SIZE = new XContentBuilderString("expected_recovered_size");
        static final XContentBuilderString EXPECTED_RECOVERED_SIZE_IN_BYTES = new XContentBuilderString("expected_recovered_size_in_bytes");
        static final XContentBuilderString RECOVERED_SIZE = new XContentBuilderString("recovered_size");
        static final XContentBuilderString RECOVERED_SIZE_IN_BYTES = new XContentBuilderString("recovered_size_in_bytes");
        static final XContentBuilderString RECOVERED = new XContentBuilderString("recovered");
        static final XContentBuilderString GATEWAY_RECOVERY = new XContentBuilderString("gateway_recovery");
        static final XContentBuilderString GATEWAY_SNAPSHOT = new XContentBuilderString("gateway_snapshot");
        static final XContentBuilderString EXPECTED_OPERATIONS = new XContentBuilderString("expected_operations");

        Fields() {
        }
    }
}

