/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.segments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;

public class IndexSegments
implements Iterable<IndexShardSegments> {
    private final String index;
    private final Map<Integer, IndexShardSegments> indexShards;

    IndexSegments(String index2, ShardSegments[] shards) {
        this.index = index2;
        HashMap tmpIndexShards = Maps.newHashMap();
        for (ShardSegments shard : shards) {
            ArrayList<ShardSegments> lst = (ArrayList<ShardSegments>)tmpIndexShards.get(shard.shardRouting().id());
            if (lst == null) {
                lst = Lists.newArrayList();
                tmpIndexShards.put(shard.shardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = Maps.newHashMap();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardSegments(((ShardSegments)((List)entry.getValue()).get(0)).shardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardSegments[((List)entry.getValue()).size()])));
        }
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public Map<Integer, IndexShardSegments> shards() {
        return this.indexShards;
    }

    public Map<Integer, IndexShardSegments> getShards() {
        return this.shards();
    }

    @Override
    public Iterator<IndexShardSegments> iterator() {
        return this.indexShards.values().iterator();
    }
}

