/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.exists.types;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class TypesExistsRequest
extends MasterNodeOperationRequest<TypesExistsRequest> {
    private String[] indices;
    private String[] types;
    private IgnoreIndices ignoreIndices = IgnoreIndices.NONE;

    TypesExistsRequest() {
    }

    public TypesExistsRequest(String[] indices2, String ... types) {
        this.indices = indices2;
        this.types = types;
    }

    public String[] indices() {
        return this.indices;
    }

    public void indices(String[] indices2) {
        this.indices = indices2;
    }

    public String[] types() {
        return this.types;
    }

    public void types(String[] types) {
        this.types = types;
    }

    public IgnoreIndices ignoreIndices() {
        return this.ignoreIndices;
    }

    public TypesExistsRequest ignoreIndices(IgnoreIndices ignoreIndices) {
        this.ignoreIndices = ignoreIndices;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("index/indices is missing", validationException);
        }
        if (this.types == null || this.types.length == 0) {
            validationException = ValidateActions.addValidationError("type/types is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        out.writeByte(this.ignoreIndices.id());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.ignoreIndices = IgnoreIndices.fromId(in.readByte());
    }
}

