/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.exists.indices;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesExistsAction
extends TransportMasterNodeOperationAction<IndicesExistsRequest, IndicesExistsResponse> {
    @Inject
    public TransportIndicesExistsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/exists";
    }

    @Override
    protected IndicesExistsRequest newRequest() {
        return new IndicesExistsRequest(new String[0]);
    }

    @Override
    protected IndicesExistsResponse newResponse() {
        return new IndicesExistsResponse();
    }

    @Override
    protected void doExecute(IndicesExistsRequest request, ActionListener<IndicesExistsResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesExistsRequest request, ClusterState state2) {
        return state2.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, request.indices());
    }

    @Override
    protected IndicesExistsResponse masterOperation(IndicesExistsRequest request, ClusterState state2) throws ElasticSearchException {
        boolean exists = true;
        for (String index2 : request.indices()) {
            if (state2.metaData().hasConcreteIndex(index2)) continue;
            exists = false;
        }
        return new IndicesExistsResponse(exists);
    }
}

