/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.exists.indices;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesExistsRequest
extends MasterNodeOperationRequest<IndicesExistsRequest> {
    private String[] indices = Strings.EMPTY_ARRAY;

    public IndicesExistsRequest(String ... indices2) {
        this.indices = indices2;
    }

    public String[] indices() {
        return this.indices;
    }

    public void indices(String[] indices2) {
        this.indices = indices2;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null || this.indices.length == 0) {
            validationException = ValidateActions.addValidationError("index/indices is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
    }
}

