/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AnalyzeResponse
extends ActionResponse
implements Iterable<AnalyzeToken>,
ToXContent {
    private List<AnalyzeToken> tokens;

    AnalyzeResponse() {
    }

    public AnalyzeResponse(List<AnalyzeToken> tokens) {
        this.tokens = tokens;
    }

    public List<AnalyzeToken> tokens() {
        return this.tokens;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens();
    }

    @Override
    public Iterator<AnalyzeToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        String format = params2.param("format", "detailed");
        if ("detailed".equals(format)) {
            builder.startArray("tokens");
            for (AnalyzeToken token : this.tokens) {
                builder.startObject();
                builder.field("token", token.term());
                builder.field("start_offset", token.startOffset());
                builder.field("end_offset", token.endOffset());
                builder.field("type", token.type());
                builder.field("position", token.position());
                builder.endObject();
            }
            builder.endArray();
        } else if ("text".equals(format)) {
            StringBuilder sb = new StringBuilder();
            int lastPosition = 0;
            for (AnalyzeToken token : this.tokens) {
                if (lastPosition != token.position()) {
                    if (lastPosition != 0) {
                        sb.append("\n").append(token.position()).append(": \n");
                    }
                    lastPosition = token.position();
                }
                sb.append('[').append(token.term()).append(":").append(token.startOffset()).append("->").append(token.endOffset()).append(":").append(token.type()).append("]\n");
            }
            builder.field("tokens", (Object)sb);
        }
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size2 = in.readVInt();
        this.tokens = new ArrayList<AnalyzeToken>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.tokens.add(AnalyzeToken.readAnalyzeToken(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.tokens.size());
        for (AnalyzeToken token : this.tokens) {
            token.writeTo(out);
        }
    }

    public static class AnalyzeToken
    implements Streamable {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private String type;

        AnalyzeToken() {
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, String type2) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type2;
        }

        public String term() {
            return this.term;
        }

        public String getTerm() {
            return this.term();
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int getStartOffset() {
            return this.startOffset();
        }

        public int endOffset() {
            return this.endOffset;
        }

        public int getEndOffset() {
            return this.endOffset();
        }

        public int position() {
            return this.position;
        }

        public int getPosition() {
            return this.position();
        }

        public String type() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        public static AnalyzeToken readAnalyzeToken(StreamInput in) throws IOException {
            AnalyzeToken analyzeToken = new AnalyzeToken();
            analyzeToken.readFrom(in);
            return analyzeToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            this.type = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            out.writeOptionalString(this.type);
        }
    }
}

