/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AnalyzeRequest
extends SingleCustomOperationRequest<AnalyzeRequest> {
    private String index;
    private String text;
    private String analyzer;
    private String tokenizer;
    private String[] tokenFilters;
    private String field;

    AnalyzeRequest() {
    }

    public AnalyzeRequest(String text) {
        this.text = text;
    }

    public AnalyzeRequest(@Nullable String index2, String text) {
        this.index = index2;
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public AnalyzeRequest index(String index2) {
        this.index = index2;
        return this;
    }

    public String index() {
        return this.index;
    }

    public AnalyzeRequest analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest tokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public String tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest tokenFilters(String ... tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public String[] tokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest field(String field2) {
        this.field = field2;
        return this;
    }

    public String field() {
        return this.field;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.text == null) {
            validationException = ValidateActions.addValidationError("text is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readOptionalString();
        this.text = in.readString();
        this.analyzer = in.readOptionalString();
        this.tokenizer = in.readOptionalString();
        int size2 = in.readVInt();
        if (size2 > 0) {
            this.tokenFilters = new String[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                this.tokenFilters[i2] = in.readString();
            }
        }
        this.field = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.index);
        out.writeString(this.text);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.tokenizer);
        if (this.tokenFilters == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.tokenFilters.length);
            for (String tokenFilter : this.tokenFilters) {
                out.writeString(tokenFilter);
            }
        }
        out.writeOptionalString(this.field);
    }
}

