/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportMasterNodeOperationAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private final AllocationService allocationService;
    private final DynamicSettings dynamicSettings;

    @Inject
    public TransportClusterUpdateSettingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, @ClusterDynamicSettings DynamicSettings dynamicSettings) {
        super(settings, transportService, clusterService, threadPool);
        this.allocationService = allocationService;
        this.dynamicSettings = dynamicSettings;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "cluster/settings/update";
    }

    @Override
    protected ClusterUpdateSettingsRequest newRequest() {
        return new ClusterUpdateSettingsRequest();
    }

    @Override
    protected ClusterUpdateSettingsResponse newResponse() {
        return new ClusterUpdateSettingsResponse();
    }

    @Override
    protected ClusterUpdateSettingsResponse masterOperation(final ClusterUpdateSettingsRequest request, ClusterState state2) throws ElasticSearchException {
        AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final CountDownLatch latch = new CountDownLatch(1);
        this.clusterService.submitStateUpdateTask("cluster_update_settings", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                ImmutableSettings.Builder persistentSettings;
                ImmutableSettings.Builder transientSettings;
                block11: {
                    boolean changed = false;
                    transientSettings = ImmutableSettings.settingsBuilder();
                    transientSettings.put(currentState.metaData().transientSettings());
                    for (Map.Entry entry : request.transientSettings().getAsMap().entrySet()) {
                        if (TransportClusterUpdateSettingsAction.this.dynamicSettings.hasDynamicSetting((String)entry.getKey()) || ((String)entry.getKey()).startsWith("logger.")) {
                            transientSettings.put((String)entry.getKey(), (String)entry.getValue());
                            changed = true;
                            continue;
                        }
                        TransportClusterUpdateSettingsAction.this.logger.warn("ignoring transient setting [{}], not dynamically updateable", entry.getKey());
                    }
                    persistentSettings = ImmutableSettings.settingsBuilder();
                    persistentSettings.put(currentState.metaData().persistentSettings());
                    for (Map.Entry entry : request.persistentSettings().getAsMap().entrySet()) {
                        if (TransportClusterUpdateSettingsAction.this.dynamicSettings.hasDynamicSetting((String)entry.getKey()) || ((String)entry.getKey()).startsWith("logger.")) {
                            changed = true;
                            persistentSettings.put((String)entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        TransportClusterUpdateSettingsAction.this.logger.warn("ignoring persistent setting [{}], not dynamically updateable", entry.getKey());
                    }
                    if (changed) break block11;
                    latch.countDown();
                    ClusterState i$ = currentState;
                    return i$;
                }
                try {
                    boolean updatedReadOnly;
                    MetaData.Builder metaData = MetaData.builder().metaData(currentState.metaData()).persistentSettings(persistentSettings.build()).transientSettings(transientSettings.build());
                    ClusterBlocks.Builder blocks2 = ClusterBlocks.builder().blocks(currentState.blocks());
                    boolean bl = updatedReadOnly = metaData.persistentSettings().getAsBoolean("cluster.blocks.read_only", false) != false || metaData.transientSettings().getAsBoolean("cluster.blocks.read_only", false) != false;
                    if (updatedReadOnly) {
                        blocks2.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                    } else {
                        blocks2.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                    }
                    ClusterState clusterState = ClusterState.builder().state(currentState).metaData(metaData).blocks(blocks2).build();
                    return clusterState;
                }
                catch (Exception e) {
                    latch.countDown();
                    TransportClusterUpdateSettingsAction.this.logger.warn("failed to update cluster settings", e, new Object[0]);
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", new ClusterStateUpdateTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        try {
                            RoutingAllocation.Result routingResult = TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState);
                            ClusterState clusterState = ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).build();
                            return clusterState;
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return new ClusterUpdateSettingsResponse();
    }
}

