/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodesInfoResponse
extends NodesOperationResponse<NodeInfo>
implements ToXContent {
    private SettingsFilter settingsFilter;

    public NodesInfoResponse() {
    }

    public NodesInfoResponse(ClusterName clusterName, NodeInfo[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new NodeInfo[in.readVInt()];
        for (int i2 = 0; i2 < ((NodeInfo[])this.nodes).length; ++i2) {
            ((NodeInfo[])this.nodes)[i2] = NodeInfo.readNodeInfo(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeInfo[])this.nodes).length);
        for (NodeInfo node : (NodeInfo[])this.nodes) {
            node.writeTo(out);
        }
    }

    public NodesInfoResponse settingsFilter(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.field("cluster_name", this.clusterName().value());
        builder.startObject("nodes");
        for (NodeInfo nodeInfo : this) {
            builder.startObject(nodeInfo.node().id(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("name", nodeInfo.node().name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("transport_address", nodeInfo.node().address().toString());
            if (nodeInfo.hostname() != null) {
                builder.field("hostname", nodeInfo.hostname(), XContentBuilder.FieldCaseConversion.NONE);
            }
            if (nodeInfo.version() != null) {
                builder.field("version", (Object)nodeInfo.version());
            }
            if (nodeInfo.serviceAttributes() != null) {
                for (Map.Entry nodeAttribute : nodeInfo.serviceAttributes().entrySet()) {
                    builder.field((String)nodeAttribute.getKey(), (String)nodeAttribute.getValue());
                }
            }
            if (!nodeInfo.node().attributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry attr2 : nodeInfo.node().attributes().entrySet()) {
                    builder.field((String)attr2.getKey(), (String)attr2.getValue());
                }
                builder.endObject();
            }
            if (nodeInfo.settings() != null) {
                builder.startObject("settings");
                Settings settings = this.settingsFilter.filterSettings(nodeInfo.settings());
                for (Map.Entry entry : settings.getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if (nodeInfo.os() != null) {
                nodeInfo.os().toXContent(builder, params2);
            }
            if (nodeInfo.process() != null) {
                nodeInfo.process().toXContent(builder, params2);
            }
            if (nodeInfo.jvm() != null) {
                nodeInfo.jvm().toXContent(builder, params2);
            }
            if (nodeInfo.threadPool() != null) {
                nodeInfo.threadPool().toXContent(builder, params2);
            }
            if (nodeInfo.network() != null) {
                nodeInfo.network().toXContent(builder, params2);
            }
            if (nodeInfo.transport() != null) {
                nodeInfo.transport().toXContent(builder, params2);
            }
            if (nodeInfo.http() != null) {
                nodeInfo.http().toXContent(builder, params2);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

