/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.health.ClusterIndexHealth;
import org.elasticsearch.action.admin.cluster.health.ClusterShardHealth;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeOperationAction<ClusterHealthRequest, ClusterHealthResponse> {
    private final ClusterName clusterName;

    @Inject
    public TransportClusterHealthAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ClusterName clusterName) {
        super(settings, transportService, clusterService, threadPool);
        this.clusterName = clusterName;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "cluster/health";
    }

    @Override
    protected ClusterHealthRequest newRequest() {
        return new ClusterHealthRequest();
    }

    @Override
    protected ClusterHealthResponse newResponse() {
        return new ClusterHealthResponse();
    }

    @Override
    protected ClusterHealthResponse masterOperation(ClusterHealthRequest request, ClusterState unusedState) throws ElasticSearchException {
        int waitFor = 5;
        if (request.waitForStatus() == null) {
            --waitFor;
        }
        if (request.waitForRelocatingShards() == -1) {
            --waitFor;
        }
        if (request.waitForActiveShards() == -1) {
            --waitFor;
        }
        if (request.waitForNodes().isEmpty()) {
            --waitFor;
        }
        if (request.indices().length == 0) {
            --waitFor;
        }
        if (waitFor == 0) {
            ClusterState clusterState = this.clusterService.state();
            return this.clusterHealth(request, clusterState);
        }
        long endTime = System.currentTimeMillis() + request.timeout().millis();
        while (true) {
            int waitForCounter = 0;
            ClusterState clusterState = this.clusterService.state();
            ClusterHealthResponse response = this.clusterHealth(request, clusterState);
            if (request.waitForStatus() != null && response.status().value() <= request.waitForStatus().value()) {
                ++waitForCounter;
            }
            if (request.waitForRelocatingShards() != -1 && response.relocatingShards() <= request.waitForRelocatingShards()) {
                ++waitForCounter;
            }
            if (request.waitForActiveShards() != -1 && response.activeShards() >= request.waitForActiveShards()) {
                ++waitForCounter;
            }
            if (request.indices().length > 0) {
                try {
                    clusterState.metaData().concreteIndices(request.indices());
                    ++waitForCounter;
                }
                catch (IndexMissingException e) {
                    response.status = ClusterHealthStatus.RED;
                }
            }
            if (!request.waitForNodes().isEmpty()) {
                if (request.waitForNodes().startsWith(">=")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(2));
                    if (response.numberOfNodes() >= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("ge(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.numberOfNodes() >= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("<=")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(2));
                    if (response.numberOfNodes() <= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("le(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.numberOfNodes() <= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith(">")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(1));
                    if (response.numberOfNodes() > expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("gt(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.numberOfNodes() > expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("<")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(1));
                    if (response.numberOfNodes() < expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("lt(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.numberOfNodes() < expected) {
                        ++waitForCounter;
                    }
                } else {
                    int expected = Integer.parseInt(request.waitForNodes());
                    if (response.numberOfNodes() == expected) {
                        ++waitForCounter;
                    }
                }
            }
            if (waitForCounter == waitFor) {
                return response;
            }
            if (System.currentTimeMillis() > endTime) {
                response.timedOut = true;
                return response;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                response.timedOut = true;
                return response;
            }
        }
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState) {
        RoutingTableValidation validation = clusterState.routingTable().validate(clusterState.metaData());
        ClusterHealthResponse response = new ClusterHealthResponse(this.clusterName.value(), validation.failures());
        response.numberOfNodes = clusterState.nodes().size();
        response.numberOfDataNodes = clusterState.nodes().dataNodes().size();
        for (String index2 : clusterState.metaData().concreteIndicesIgnoreMissing(request.indices())) {
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(index2);
            IndexMetaData indexMetaData = clusterState.metaData().index(index2);
            if (indexRoutingTable == null) continue;
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(index2, indexMetaData.numberOfShards(), indexMetaData.numberOfReplicas(), validation.indexFailures(indexMetaData.index()));
            for (IndexShardRoutingTable shardRoutingTable : indexRoutingTable) {
                ClusterShardHealth shardHealth = new ClusterShardHealth(shardRoutingTable.shardId().id());
                for (ShardRouting shardRouting : shardRoutingTable) {
                    if (shardRouting.active()) {
                        ++shardHealth.activeShards;
                        if (shardRouting.relocating()) {
                            ++shardHealth.relocatingShards;
                        }
                        if (!shardRouting.primary()) continue;
                        shardHealth.primaryActive = true;
                        continue;
                    }
                    if (shardRouting.initializing()) {
                        ++shardHealth.initializingShards;
                        continue;
                    }
                    if (!shardRouting.unassigned()) continue;
                    ++shardHealth.unassignedShards;
                }
                shardHealth.status = shardHealth.primaryActive ? (shardHealth.activeShards == shardRoutingTable.size() ? ClusterHealthStatus.GREEN : ClusterHealthStatus.YELLOW) : ClusterHealthStatus.RED;
                indexHealth.shards.put(shardHealth.id(), shardHealth);
            }
            for (ClusterShardHealth shardHealth : indexHealth) {
                if (shardHealth.primaryActive()) {
                    ++indexHealth.activePrimaryShards;
                }
                indexHealth.activeShards += shardHealth.activeShards;
                indexHealth.relocatingShards += shardHealth.relocatingShards;
                indexHealth.initializingShards += shardHealth.initializingShards;
                indexHealth.unassignedShards += shardHealth.unassignedShards;
            }
            indexHealth.status = ClusterHealthStatus.GREEN;
            if (!indexHealth.validationFailures().isEmpty()) {
                indexHealth.status = ClusterHealthStatus.RED;
            } else if (indexHealth.shards().isEmpty()) {
                indexHealth.status = ClusterHealthStatus.RED;
            } else {
                for (ClusterShardHealth shardHealth : indexHealth) {
                    if (shardHealth.status() == ClusterHealthStatus.RED) {
                        indexHealth.status = ClusterHealthStatus.RED;
                        break;
                    }
                    if (shardHealth.status() != ClusterHealthStatus.YELLOW) continue;
                    indexHealth.status = ClusterHealthStatus.YELLOW;
                }
            }
            response.indices.put(indexHealth.index(), indexHealth);
        }
        for (ClusterIndexHealth indexHealth : response) {
            response.activePrimaryShards += indexHealth.activePrimaryShards;
            response.activeShards += indexHealth.activeShards;
            response.relocatingShards += indexHealth.relocatingShards;
            response.initializingShards += indexHealth.initializingShards;
            response.unassignedShards += indexHealth.unassignedShards;
        }
        response.status = ClusterHealthStatus.GREEN;
        if (!response.validationFailures().isEmpty()) {
            response.status = ClusterHealthStatus.RED;
        } else if (clusterState.blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
            response.status = ClusterHealthStatus.RED;
        } else {
            for (ClusterIndexHealth indexHealth : response) {
                if (indexHealth.status() == ClusterHealthStatus.RED) {
                    response.status = ClusterHealthStatus.RED;
                    break;
                }
                if (indexHealth.status() != ClusterHealthStatus.YELLOW) continue;
                response.status = ClusterHealthStatus.YELLOW;
            }
        }
        return response;
    }
}

