/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Serializable {
    public static final int V_0_18_0_ID = 180099;
    public static final Version V_0_18_0 = new Version(180099, false);
    public static final int V_0_18_1_ID = 180199;
    public static final Version V_0_18_1 = new Version(180199, false);
    public static final int V_0_18_2_ID = 180299;
    public static final Version V_0_18_2 = new Version(180299, false);
    public static final int V_0_18_3_ID = 180399;
    public static final Version V_0_18_3 = new Version(180399, false);
    public static final int V_0_18_4_ID = 180499;
    public static final Version V_0_18_4 = new Version(180499, false);
    public static final int V_0_18_5_ID = 180599;
    public static final Version V_0_18_5 = new Version(180599, false);
    public static final int V_0_18_6_ID = 180699;
    public static final Version V_0_18_6 = new Version(180699, false);
    public static final int V_0_18_7_ID = 180799;
    public static final Version V_0_18_7 = new Version(180799, false);
    public static final int V_0_18_8_ID = 180899;
    public static final Version V_0_18_8 = new Version(180899, false);
    public static final int V_0_19_0_RC1_ID = 190051;
    public static final Version V_0_19_0_RC1 = new Version(190051, false);
    public static final int V_0_19_0_RC2_ID = 190052;
    public static final Version V_0_19_0_RC2 = new Version(190052, false);
    public static final int V_0_19_0_RC3_ID = 190053;
    public static final Version V_0_19_0_RC3 = new Version(190053, false);
    public static final int V_0_19_0_ID = 190099;
    public static final Version V_0_19_0 = new Version(190099, false);
    public static final int V_0_19_1_ID = 190199;
    public static final Version V_0_19_1 = new Version(190199, false);
    public static final int V_0_19_2_ID = 190299;
    public static final Version V_0_19_2 = new Version(190299, false);
    public static final int V_0_19_3_ID = 190399;
    public static final Version V_0_19_3 = new Version(190399, false);
    public static final int V_0_19_4_ID = 190499;
    public static final Version V_0_19_4 = new Version(190499, false);
    public static final int V_0_19_5_ID = 190599;
    public static final Version V_0_19_5 = new Version(190599, false);
    public static final int V_0_19_6_ID = 190699;
    public static final Version V_0_19_6 = new Version(190699, false);
    public static final int V_0_19_7_ID = 190799;
    public static final Version V_0_19_7 = new Version(190799, false);
    public static final int V_0_19_8_ID = 190899;
    public static final Version V_0_19_8 = new Version(190899, false);
    public static final int V_0_19_9_ID = 190999;
    public static final Version V_0_19_9 = new Version(190999, false);
    public static final int V_0_19_10_ID = 191099;
    public static final Version V_0_19_10 = new Version(191099, false);
    public static final int V_0_19_11_ID = 191199;
    public static final Version V_0_19_11 = new Version(191199, false);
    public static final int V_0_19_12_ID = 191299;
    public static final Version V_0_19_12 = new Version(191299, false);
    public static final int V_0_19_13_ID = 191399;
    public static final Version V_0_19_13 = new Version(191399, false);
    public static final int V_0_20_0_RC1_ID = 200051;
    public static final Version V_0_20_0_RC1 = new Version(200051, false);
    public static final int V_0_20_0_ID = 200099;
    public static final Version V_0_20_0 = new Version(200099, false);
    public static final int V_0_20_1_ID = 200199;
    public static final Version V_0_20_1 = new Version(200199, false);
    public static final int V_0_20_2_ID = 200299;
    public static final Version V_0_20_2 = new Version(200299, false);
    public static final int V_0_20_3_ID = 200399;
    public static final Version V_0_20_3 = new Version(200399, false);
    public static final int V_0_20_4_ID = 200499;
    public static final Version V_0_20_4 = new Version(200499, false);
    public static final int V_0_20_5_ID = 200599;
    public static final Version V_0_20_5 = new Version(200599, false);
    public static final int V_0_20_6_ID = 200699;
    public static final Version V_0_20_6;
    public static final Version CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final Boolean snapshot;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id2) {
        switch (id2) {
            case 200699: {
                return V_0_20_6;
            }
            case 200599: {
                return V_0_20_5;
            }
            case 200499: {
                return V_0_20_4;
            }
            case 200399: {
                return V_0_20_3;
            }
            case 200299: {
                return V_0_20_2;
            }
            case 200199: {
                return V_0_20_1;
            }
            case 200099: {
                return V_0_20_0;
            }
            case 200051: {
                return V_0_20_0_RC1;
            }
            case 190051: {
                return V_0_19_0_RC1;
            }
            case 190052: {
                return V_0_19_0_RC2;
            }
            case 190053: {
                return V_0_19_0_RC3;
            }
            case 190099: {
                return V_0_19_0;
            }
            case 190199: {
                return V_0_19_1;
            }
            case 190299: {
                return V_0_19_2;
            }
            case 190399: {
                return V_0_19_3;
            }
            case 190499: {
                return V_0_19_4;
            }
            case 190599: {
                return V_0_19_5;
            }
            case 190699: {
                return V_0_19_6;
            }
            case 190799: {
                return V_0_19_7;
            }
            case 190899: {
                return V_0_19_8;
            }
            case 190999: {
                return V_0_19_9;
            }
            case 191099: {
                return V_0_19_10;
            }
            case 191199: {
                return V_0_19_11;
            }
            case 191299: {
                return V_0_19_12;
            }
            case 191399: {
                return V_0_19_13;
            }
            case 180099: {
                return V_0_18_0;
            }
            case 180199: {
                return V_0_18_1;
            }
            case 180299: {
                return V_0_18_2;
            }
            case 180399: {
                return V_0_18_3;
            }
            case 180499: {
                return V_0_18_4;
            }
            case 180599: {
                return V_0_18_5;
            }
            case 180699: {
                return V_0_18_6;
            }
            case 180799: {
                return V_0_18_7;
            }
            case 180899: {
                return V_0_18_8;
            }
        }
        return new Version(id2, null);
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    Version(int id2, @Nullable Boolean snapshot) {
        this.id = id2;
        this.major = (byte)(id2 / 1000000 % 100);
        this.minor = (byte)(id2 / 10000 % 100);
        this.revision = (byte)(id2 / 100 % 100);
        this.build = (byte)(id2 % 100);
        this.snapshot = snapshot;
    }

    public boolean snapshot() {
        return this.snapshot != null && this.snapshot != false;
    }

    public boolean after(Version version) {
        return version.id > this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id >= this.id;
    }

    public boolean before(Version version) {
        return version.id < this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id <= this.id;
    }

    public String number() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.build < 50) {
            sb.append(".Beta").append(this.build);
        } else if (this.build < 99) {
            sb.append(".RC").append(this.build - 50);
        }
        return sb.toString();
    }

    public static void main(String[] args2) {
        System.out.println("ElasticSearch Version: " + CURRENT + ", JVM: " + JvmInfo.jvmInfo().vmVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.number());
        if (this.snapshot()) {
            sb.append("-SNAPSHOT");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    static {
        CURRENT = V_0_20_6 = new Version(200699, false);
    }
}

