/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.util.StringRangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBSONList
extends ArrayList<Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    @Override
    public Object put(String key2, Object v) {
        return this.put(this._getInt(key2), v);
    }

    public Object put(int key2, Object v) {
        while (key2 >= this.size()) {
            this.add(null);
        }
        this.set(key2, v);
        return v;
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    @Override
    public Object get(String key2) {
        int i2 = this._getInt(key2);
        if (i2 < 0) {
            return null;
        }
        if (i2 >= this.size()) {
            return null;
        }
        return this.get(i2);
    }

    @Override
    public Object removeField(String key2) {
        int i2 = this._getInt(key2);
        if (i2 < 0) {
            return null;
        }
        if (i2 >= this.size()) {
            return null;
        }
        return this.remove(i2);
    }

    @Override
    @Deprecated
    public boolean containsKey(String key2) {
        return this.containsField(key2);
    }

    @Override
    public boolean containsField(String key2) {
        int i2 = this._getInt(key2, false);
        if (i2 < 0) {
            return false;
        }
        return i2 >= 0 && i2 < this.size();
    }

    @Override
    public Set<String> keySet() {
        return new StringRangeSet(this.size());
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String s2 : this.keySet()) {
            m.put(s2, this.get(String.valueOf(s2)));
        }
        return m;
    }

    int _getInt(String s2) {
        return this._getInt(s2, true);
    }

    int _getInt(String s2, boolean err) {
        try {
            return Integer.parseInt(s2);
        }
        catch (Exception e) {
            if (err) {
                throw new IllegalArgumentException("BasicBSONList can only work with numeric keys, not: [" + s2 + "]");
            }
            return -1;
        }
    }
}

