/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.util.JSON;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBSONObject
extends LinkedHashMap<String, Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    public BasicBSONObject() {
    }

    public BasicBSONObject(int size2) {
        super(size2);
    }

    public BasicBSONObject(String key2, Object value2) {
        this.put(key2, value2);
    }

    public BasicBSONObject(Map m) {
        super(m);
    }

    @Override
    public Map toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    @Override
    public Object removeField(String key2) {
        return this.remove(key2);
    }

    @Override
    public boolean containsField(String field2) {
        return super.containsKey(field2);
    }

    @Override
    @Deprecated
    public boolean containsKey(String key2) {
        return this.containsField(key2);
    }

    @Override
    public Object get(String key2) {
        return super.get(key2);
    }

    public int getInt(String key2) {
        Object o = this.get(key2);
        if (o == null) {
            throw new NullPointerException("no value for: " + key2);
        }
        return BSON.toInt(o);
    }

    public int getInt(String key2, int def) {
        Object foo = this.get(key2);
        if (foo == null) {
            return def;
        }
        return BSON.toInt(foo);
    }

    public long getLong(String key2) {
        Object foo = this.get(key2);
        return ((Number)foo).longValue();
    }

    public long getLong(String key2, long def) {
        Object foo = this.get(key2);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).longValue();
    }

    public double getDouble(String key2) {
        Object foo = this.get(key2);
        return ((Number)foo).doubleValue();
    }

    public double getDouble(String key2, double def) {
        Object foo = this.get(key2);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).doubleValue();
    }

    public String getString(String key2) {
        Object foo = this.get(key2);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public String getString(String key2, String def) {
        Object foo = this.get(key2);
        if (foo == null) {
            return def;
        }
        return foo.toString();
    }

    public boolean getBoolean(String key2) {
        return this.getBoolean(key2, false);
    }

    public boolean getBoolean(String key2, boolean def) {
        Object foo = this.get(key2);
        if (foo == null) {
            return def;
        }
        if (foo instanceof Number) {
            return ((Number)foo).intValue() > 0;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + foo.getClass());
    }

    public ObjectId getObjectId(String field2) {
        return (ObjectId)this.get(field2);
    }

    public ObjectId getObjectId(String field2, ObjectId def) {
        Object foo = this.get(field2);
        return foo != null ? (ObjectId)foo : def;
    }

    public Date getDate(String field2) {
        return (Date)this.get(field2);
    }

    public Date getDate(String field2, Date def) {
        Object foo = this.get(field2);
        return foo != null ? (Date)foo : def;
    }

    @Override
    public Object put(String key2, Object val) {
        return super.put(key2, val);
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public BasicBSONObject append(String key2, Object val) {
        this.put(key2, val);
        return this;
    }

    @Override
    public String toString() {
        return JSON.serialize((Object)this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BSONObject)) {
            return false;
        }
        BSONObject other = (BSONObject)o;
        if (!((Object)this.keySet()).equals(other.keySet())) {
            return false;
        }
        for (String key2 : this.keySet()) {
            Object a = this.get(key2);
            Object b = other.get(key2);
            if (a == null && b != null) {
                return false;
            }
            if (b == null) {
                if (a == null) continue;
                return false;
            }
            if (a instanceof Number && b instanceof Number) {
                if (((Number)a).doubleValue() == ((Number)b).doubleValue()) continue;
                return false;
            }
            if (a instanceof Pattern && b instanceof Pattern) {
                Pattern p1 = (Pattern)a;
                Pattern p2 = (Pattern)b;
                if (p1.pattern().equals(p2.pattern()) && p1.flags() == p2.flags()) continue;
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }
}

