/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.openssl.PEMUtilities;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PKCS8Generator
implements PemObjectGenerator {
    public static final String AES_128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES_192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES_256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String DES3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String PBE_SHA1_RC4_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId();
    public static final String PBE_SHA1_RC4_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4.getId();
    public static final String PBE_SHA1_3DES = PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_2DES = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_RC2_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC.getId();
    public static final String PBE_SHA1_RC2_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC.getId();
    private char[] password;
    private String algorithm;
    private int iterationCount;
    private PrivateKey key;
    private Cipher cipher;
    private SecureRandom random;
    private AlgorithmParameterGenerator paramGen;
    private SecretKeyFactory secKeyFact;

    public PKCS8Generator(PrivateKey privateKey) {
        this.key = privateKey;
    }

    public PKCS8Generator(PrivateKey privateKey, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException {
        Provider provider = Security.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider: " + string3);
        }
        this.init(privateKey, string2, provider);
    }

    public PKCS8Generator(PrivateKey privateKey, String string2, Provider provider) throws NoSuchAlgorithmException {
        this.init(privateKey, string2, provider);
    }

    private void init(PrivateKey privateKey, String string2, Provider provider) throws NoSuchAlgorithmException {
        this.key = privateKey;
        this.algorithm = string2;
        this.iterationCount = 2048;
        try {
            this.cipher = Cipher.getInstance(string2, provider);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(string2 + " found, but padding not available: " + noSuchPaddingException.getMessage());
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string2);
        if (PEMUtilities.isPKCS5Scheme2(aSN1ObjectIdentifier)) {
            this.paramGen = AlgorithmParameterGenerator.getInstance(string2, provider);
        } else {
            this.secKeyFact = SecretKeyFactory.getInstance(string2, provider);
        }
    }

    public PKCS8Generator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PKCS8Generator setPassword(char[] cArray) {
        this.password = cArray;
        return this;
    }

    public PKCS8Generator setIterationCount(int n) {
        this.iterationCount = n;
        return this;
    }

    public PemObject generate() throws PemGenerationException {
        byte[] byArray = this.key.getEncoded();
        if (this.algorithm == null) {
            return new PemObject("PRIVATE KEY", byArray);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(this.algorithm);
        if (PEMUtilities.isPKCS5Scheme2(aSN1ObjectIdentifier)) {
            byte[] byArray2 = new byte[20];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray2);
            SecretKey secretKey = PEMUtilities.generateSecretKeyForPKCS5Scheme2(this.algorithm, this.password, byArray2, this.iterationCount);
            AlgorithmParameters algorithmParameters = this.paramGen.generateParameters();
            try {
                this.cipher.init(1, (Key)secretKey, algorithmParameters);
                EncryptionScheme encryptionScheme = new EncryptionScheme(new ASN1ObjectIdentifier(this.algorithm), (ASN1Encodable)ASN1Primitive.fromByteArray(algorithmParameters.getEncoded()));
                KeyDerivationFunc keyDerivationFunc = new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(byArray2, this.iterationCount));
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(keyDerivationFunc);
                aSN1EncodableVector.add(encryptionScheme);
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)new PBES2Parameters(new DERSequence(aSN1EncodableVector))), this.cipher.doFinal(byArray));
                return new PemObject("ENCRYPTED PRIVATE KEY", encryptedPrivateKeyInfo.getEncoded());
            }
            catch (IOException iOException) {
                throw new PemGenerationException(iOException.getMessage(), iOException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PemGenerationException(generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        if (PEMUtilities.isPKCS12(aSN1ObjectIdentifier)) {
            byte[] byArray3 = new byte[20];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray3);
            try {
                PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password);
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, this.iterationCount);
                this.cipher.init(1, (Key)this.secKeyFact.generateSecret(pBEKeySpec), pBEParameterSpec);
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(new DEROctetString(byArray3));
                aSN1EncodableVector.add(new ASN1Integer(this.iterationCount));
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)PKCS12PBEParams.getInstance(new DERSequence(aSN1EncodableVector))), this.cipher.doFinal(byArray));
                return new PemObject("ENCRYPTED PRIVATE KEY", encryptedPrivateKeyInfo.getEncoded());
            }
            catch (IOException iOException) {
                throw new PemGenerationException(iOException.getMessage(), iOException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PemGenerationException(generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        throw new PemGenerationException("unknown algorithm: " + this.algorithm);
    }
}

