/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.util.Strings;

public abstract class X509NameEntryConverter {
    protected ASN1Primitive convertHexEncoded(String string2, int n) throws IOException {
        string2 = Strings.toLowerCase(string2);
        byte[] byArray = new byte[(string2.length() - n) / 2];
        for (int j = 0; j != byArray.length; ++j) {
            char c = string2.charAt(j * 2 + n);
            char c2 = string2.charAt(j * 2 + n + 1);
            byArray[j] = c < 'a' ? (byte)(c - 48 << 4) : (byte)(c - 97 + 10 << 4);
            if (c2 < 'a') {
                int n2 = j;
                byArray[n2] = (byte)(byArray[n2] | (byte)(c2 - 48));
                continue;
            }
            int n3 = j;
            byArray[n3] = (byte)(byArray[n3] | (byte)(c2 - 97 + 10));
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    protected boolean canBePrintable(String string2) {
        return DERPrintableString.isPrintableString(string2);
    }

    public abstract ASN1Primitive getConvertedValue(ASN1ObjectIdentifier var1, String var2);
}

