/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] names;

    public static GeneralNames getInstance(Object object) {
        if (object instanceof GeneralNames) {
            return (GeneralNames)object;
        }
        if (object != null) {
            return new GeneralNames(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public GeneralNames(GeneralName generalName) {
        this.names = new GeneralName[]{generalName};
    }

    public GeneralNames(GeneralName[] generalNameArray) {
        this.names = generalNameArray;
    }

    private GeneralNames(ASN1Sequence aSN1Sequence) {
        this.names = new GeneralName[aSN1Sequence.size()];
        for (int j = 0; j != aSN1Sequence.size(); ++j) {
            this.names[j] = GeneralName.getInstance(aSN1Sequence.getObjectAt(j));
        }
    }

    public GeneralName[] getNames() {
        GeneralName[] generalNameArray = new GeneralName[this.names.length];
        System.arraycopy(this.names, 0, generalNameArray, 0, this.names.length);
        return generalNameArray;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.names);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("GeneralNames:");
        stringBuffer.append(string2);
        for (int j = 0; j != this.names.length; ++j) {
            stringBuffer.append("    ");
            stringBuffer.append(this.names[j]);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

