/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.apache.xerces.jaxp.validation.DOMValidatorHelper;
import org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import org.apache.xerces.jaxp.validation.StreamValidatorHelper;
import org.apache.xerces.jaxp.validation.ValidatorHandlerImpl;
import org.apache.xerces.jaxp.validation.XMLSchemaValidatorComponentManager;
import org.apache.xerces.jaxp.validation.XSGrammarPoolContainer;
import org.apache.xerces.util.SAXMessageFormatter;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

final class ValidatorImpl
extends Validator
implements PSVIProvider {
    private static final String CURRENT_ELEMENT_NODE = "http://apache.org/xml/properties/dom/current-element-node";
    private XMLSchemaValidatorComponentManager fComponentManager;
    private ValidatorHandlerImpl fSAXValidatorHelper;
    private DOMValidatorHelper fDOMValidatorHelper;
    private StreamValidatorHelper fStreamValidatorHelper;
    private boolean fConfigurationChanged = false;
    private boolean fErrorHandlerChanged = false;
    private boolean fResourceResolverChanged = false;

    public ValidatorImpl(XSGrammarPoolContainer xSGrammarPoolContainer) {
        this.fComponentManager = new XMLSchemaValidatorComponentManager(xSGrammarPoolContainer);
        this.setErrorHandler(null);
        this.setResourceResolver(null);
    }

    public void validate(Source source2, Result result2) throws SAXException, IOException {
        if (source2 instanceof SAXSource) {
            if (this.fSAXValidatorHelper == null) {
                this.fSAXValidatorHelper = new ValidatorHandlerImpl(this.fComponentManager);
            }
            this.fSAXValidatorHelper.validate(source2, result2);
        } else if (source2 instanceof DOMSource) {
            if (this.fDOMValidatorHelper == null) {
                this.fDOMValidatorHelper = new DOMValidatorHelper(this.fComponentManager);
            }
            this.fDOMValidatorHelper.validate(source2, result2);
        } else if (source2 instanceof StreamSource) {
            if (this.fStreamValidatorHelper == null) {
                this.fStreamValidatorHelper = new StreamValidatorHelper(this.fComponentManager);
            }
            this.fStreamValidatorHelper.validate(source2, result2);
        } else {
            if (source2 == null) {
                throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceParameterNull", null));
            }
            throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceNotAccepted", new Object[]{source2.getClass().getName()}));
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandlerChanged = errorHandler != null;
        this.fComponentManager.setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.fComponentManager.getErrorHandler();
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.fResourceResolverChanged = lSResourceResolver != null;
        this.fComponentManager.setResourceResolver(lSResourceResolver);
    }

    public LSResourceResolver getResourceResolver() {
        return this.fComponentManager.getResourceResolver();
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        try {
            return this.fComponentManager.getFeature(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            String string4 = xMLConfigurationException.getType() == 0 ? "feature-not-recognized" : "feature-not-supported";
            throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), string4, new Object[]{string3}));
        }
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        try {
            this.fComponentManager.setFeature(string2, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            String string4 = xMLConfigurationException.getType() == 0 ? "feature-not-recognized" : "feature-not-supported";
            throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), string4, new Object[]{string3}));
        }
        this.fConfigurationChanged = true;
    }

    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (CURRENT_ELEMENT_NODE.equals(string2)) {
            return this.fDOMValidatorHelper != null ? this.fDOMValidatorHelper.getCurrentElement() : null;
        }
        try {
            return this.fComponentManager.getProperty(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            String string4 = xMLConfigurationException.getType() == 0 ? "property-not-recognized" : "property-not-supported";
            throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), string4, new Object[]{string3}));
        }
    }

    public void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (CURRENT_ELEMENT_NODE.equals(string2)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "property-read-only", new Object[]{string2}));
        }
        try {
            this.fComponentManager.setProperty(string2, object);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            String string4 = xMLConfigurationException.getType() == 0 ? "property-not-recognized" : "property-not-supported";
            throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), string4, new Object[]{string3}));
        }
        this.fConfigurationChanged = true;
    }

    public void reset() {
        if (this.fConfigurationChanged) {
            this.fComponentManager.restoreInitialState();
            this.setErrorHandler(null);
            this.setResourceResolver(null);
            this.fConfigurationChanged = false;
            this.fErrorHandlerChanged = false;
            this.fResourceResolverChanged = false;
        } else {
            if (this.fErrorHandlerChanged) {
                this.setErrorHandler(null);
                this.fErrorHandlerChanged = false;
            }
            if (this.fResourceResolverChanged) {
                this.setResourceResolver(null);
                this.fResourceResolverChanged = false;
            }
        }
    }

    public ElementPSVI getElementPSVI() {
        return this.fSAXValidatorHelper != null ? this.fSAXValidatorHelper.getElementPSVI() : null;
    }

    public AttributePSVI getAttributePSVI(int n) {
        return this.fSAXValidatorHelper != null ? this.fSAXValidatorHelper.getAttributePSVI(n) : null;
    }

    public AttributePSVI getAttributePSVIByName(String string2, String string3) {
        return this.fSAXValidatorHelper != null ? this.fSAXValidatorHelper.getAttributePSVIByName(string2, string3) : null;
    }
}

