/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);
    public static final RuntimeException abort = new RuntimeException();
    public static final XMLString EMPTY_STRING = new XMLString();
    private boolean allWhitespace = false;

    protected void normalizeDocument(CoreDocumentImpl coreDocumentImpl, DOMConfigurationImpl dOMConfigurationImpl) {
        Object object;
        this.fDocument = coreDocumentImpl;
        this.fConfiguration = dOMConfigurationImpl;
        String string2 = this.fDocument.getXmlVersion();
        String string3 = null;
        String string4 = null;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        if ((this.fConfiguration.features & 0x40) != 0) {
            object = (String)this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            if (object != null && ((String)object).equals(Constants.NS_XMLSCHEMA)) {
                string3 = "http://www.w3.org/2001/XMLSchema";
                this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator(string3, string2);
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                this.fNamespaceValidation = true;
                this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            } else {
                string3 = "http://www.w3.org/TR/REC-xml";
                if (object != null) {
                    string4 = (String)this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaSource");
                }
                this.fConfiguration.setDTDValidatorFactory(string2);
                this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator(string3, string2);
                this.fPSVI = false;
            }
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fDocument.clearIdentifiers();
            if (this.fValidationHandler != null) {
                ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
            }
        } else {
            this.fValidationHandler = null;
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(new SimpleLocator(this.fDocument.fDocumentURI, this.fDocument.fDocumentURI, -1, -1), this.fDocument.encoding, this.fNamespaceContext, null);
            this.fValidationHandler.xmlDecl(this.fDocument.getXmlVersion(), this.fDocument.getXmlEncoding(), this.fDocument.getXmlStandalone() ? "yes" : "no", null);
        }
        try {
            if (string3 == "http://www.w3.org/TR/REC-xml") {
                this.processDTD(string2, string4);
            }
            object = this.fDocument.getFirstChild();
            while (object != null) {
                Object object2 = object.getNextSibling();
                if ((object = this.normalizeNode((Node)object)) != null) {
                    object2 = object;
                }
                object = object2;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                this.fValidationHandler.setDocumentHandler(null);
                CoreDOMImplementationImpl.singleton.releaseValidator(string3, string2, this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.fValidationHandler != null) {
                this.fValidationHandler.setDocumentHandler(null);
                CoreDOMImplementationImpl.singleton.releaseValidator(string3, string2, this.fValidationHandler);
                this.fValidationHandler = null;
            }
            if (runtimeException == abort) {
                return;
            }
            throw runtimeException;
        }
    }

    protected Node normalizeNode(Node node) {
        short s2 = node.getNodeType();
        this.fLocator.fRelatedNode = node;
        switch (s2) {
            case 10: {
                break;
            }
            case 1: {
                Node node2;
                int n;
                AttributeMap attributeMap;
                Object object;
                boolean bl;
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged() && !(bl = this.fNamespaceValidation ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), this.fDocument.isXML11Version()) : CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                    object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, (String)object, (short)2, "wf-invalid-character-in-node-name");
                }
                this.fNamespaceContext.pushContext();
                this.fLocalNSBinder.reset();
                object = (ElementImpl)node;
                if (((NodeImpl)object).needsSyncChildren()) {
                    ((ParentNode)object).synchronizeChildren();
                }
                AttributeMap attributeMap2 = attributeMap = ((ElementImpl)object).hasAttributes() ? (AttributeMap)((ElementImpl)object).getAttributes() : null;
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp((ElementImpl)object, attributeMap);
                    if ((this.fConfiguration.features & 0x200) == 0 && attributeMap != null) {
                        n = 0;
                        while (n < attributeMap.getLength()) {
                            node2 = (Attr)attributeMap.getItem(n);
                            if (XMLSymbols.PREFIX_XMLNS.equals(node2.getPrefix()) || XMLSymbols.PREFIX_XMLNS.equals(node2.getName())) {
                                ((ElementImpl)object).removeAttributeNode((Attr)node2);
                                --n;
                            }
                            ++n;
                        }
                    }
                } else if (attributeMap != null) {
                    n = 0;
                    while (n < attributeMap.getLength()) {
                        node2 = (Attr)attributeMap.item(n);
                        node2.normalize();
                        if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                            DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributeMap, (Attr)node2, node2.getValue(), this.fDocument.isXML11Version());
                            if (this.fDocument.isXMLVersionChanged() && !(bl = CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string2, (short)2, "wf-invalid-character-in-node-name");
                            }
                        }
                        ++n;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributeMap, this.fDocument, (ElementImpl)object);
                    this.updateQName((Node)object, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node node3 = ((ParentNode)object).getFirstChild();
                while (node3 != null) {
                    node2 = node3.getNextSibling();
                    if ((node3 = this.normalizeNode(node3)) != null) {
                        node2 = node3;
                    }
                    node3 = node2;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName((Node)object, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                if ((this.fConfiguration.features & 0x20) == 0) {
                    Node node4;
                    Node node5 = node.getPreviousSibling();
                    Node node6 = node.getParentNode();
                    node6.removeChild(node);
                    if (node5 == null || node5.getNodeType() != 3 || (node4 = node5.getNextSibling()) == null || node4.getNodeType() != 3) break;
                    ((TextImpl)node4).insertData(0, node5.getNodeValue());
                    node6.removeChild(node5);
                    return node4;
                }
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    String string3 = ((Comment)node).getData();
                    DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, string3, this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fValidationHandler.comment(EMPTY_STRING, null);
                break;
            }
            case 5: {
                if ((this.fConfiguration.features & 4) == 0) {
                    Node node7;
                    Node node8 = node.getPreviousSibling();
                    Node node9 = node.getParentNode();
                    ((EntityReferenceImpl)node).setReadOnly(false, true);
                    this.expandEntityRef(node9, node);
                    node9.removeChild(node);
                    Node node10 = node7 = node8 != null ? node8.getNextSibling() : node9.getFirstChild();
                    if (node8 != null && node7 != null && node8.getNodeType() == 3 && node7.getNodeType() == 3) {
                        return node8;
                    }
                    return node7;
                }
                if (!this.fDocument.errorChecking || (this.fConfiguration.features & 0x100) == 0 || !this.fDocument.isXMLVersionChanged()) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version());
                break;
            }
            case 4: {
                if ((this.fConfiguration.features & 8) == 0) {
                    Node node11 = node.getPreviousSibling();
                    if (node11 != null && node11.getNodeType() == 3) {
                        ((Text)node11).appendData(node.getNodeValue());
                        node.getParentNode().removeChild(node);
                        return node11;
                    }
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node node12 = node.getParentNode();
                    node = node12.replaceChild(text, node);
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                String string4 = node.getNodeValue();
                if ((this.fConfiguration.features & 0x10) != 0) {
                    int n;
                    Node node13 = node.getParentNode();
                    if (this.fDocument.errorChecking) {
                        DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                    }
                    while ((n = string4.indexOf("]]>")) >= 0) {
                        node.setNodeValue(string4.substring(0, n + 2));
                        string4 = string4.substring(n + 2);
                        Node node14 = node;
                        CDATASection cDATASection = this.fDocument.createCDATASection(string4);
                        node13.insertBefore(cDATASection, node.getNextSibling());
                        node = cDATASection;
                        this.fLocator.fRelatedNode = node14;
                        String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "cdata-sections-splitted", null);
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string5, (short)1, "cdata-sections-splitted");
                    }
                    break;
                }
                if (!this.fDocument.errorChecking) break;
                DOMNormalizer.isCDataWF(this.fErrorHandler, this.fError, this.fLocator, string4, this.fDocument.isXML11Version());
                break;
            }
            case 3: {
                int n;
                Node node15 = node.getNextSibling();
                if (node15 != null && node15.getNodeType() == 3) {
                    ((Text)node).appendData(node15.getNodeValue());
                    node.getParentNode().removeChild(node15);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                int n2 = n = node15 != null ? (int)node15.getNodeType() : -1;
                if (n != -1 && ((this.fConfiguration.features & 4) == 0 && n == 6 || (this.fConfiguration.features & 0x20) == 0 && n == 8 || (this.fConfiguration.features & 8) == 0 && n == 4)) break;
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                this.fCurrentNode = node;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
                if (!this.allWhitespace) break;
                this.allWhitespace = false;
                ((TextImpl)node).setIgnorableWhitespace(true);
                break;
            }
            case 7: {
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    String string6 = processingInstruction.getTarget();
                    boolean bl = this.fDocument.isXML11Version() ? XML11Char.isXML11ValidName(string6) : XMLChar.isValidName(string6);
                    if (!bl) {
                        String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string7, (short)2, "wf-invalid-character-in-node-name");
                    }
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, processingInstruction.getData(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fValidationHandler.processingInstruction(((ProcessingInstruction)node).getTarget(), EMPTY_STRING, null);
            }
        }
        return null;
    }

    private void processDTD(String string2, String string3) {
        Object object;
        String string4 = null;
        String string5 = null;
        String string6 = string3;
        String string7 = this.fDocument.getDocumentURI();
        String string8 = null;
        DocumentType documentType = this.fDocument.getDoctype();
        if (documentType != null) {
            string4 = documentType.getName();
            string5 = documentType.getPublicId();
            if (string6 == null || string6.length() == 0) {
                string6 = documentType.getSystemId();
            }
            string8 = documentType.getInternalSubset();
        } else {
            object = this.fDocument.getDocumentElement();
            if (object == null) {
                return;
            }
            string4 = object.getNodeName();
            if (string6 == null || string6.length() == 0) {
                return;
            }
        }
        object = null;
        try {
            try {
                this.fValidationHandler.doctypeDecl(string4, string5, string6, null);
                object = CoreDOMImplementationImpl.singleton.getDTDLoader(string2);
                ((XMLDTDLoader)object).setFeature("http://xml.org/sax/features/validation", true);
                ((XMLDTDLoader)object).setEntityResolver(this.fConfiguration.getEntityResolver());
                ((XMLDTDLoader)object).setErrorHandler(this.fConfiguration.getErrorHandler());
                ((XMLDTDLoader)object).loadGrammarWithContext((XMLDTDValidator)this.fValidationHandler, string4, string5, string6, string7, string8);
            }
            catch (IOException iOException) {
                Object var12_11 = null;
                if (object != null) {
                    CoreDOMImplementationImpl.singleton.releaseDTDLoader(string2, (XMLDTDLoader)object);
                }
            }
            Object var12_10 = null;
            if (object != null) {
                CoreDOMImplementationImpl.singleton.releaseDTDLoader(string2, (XMLDTDLoader)object);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (object != null) {
                CoreDOMImplementationImpl.singleton.releaseDTDLoader(string2, (XMLDTDLoader)object);
            }
            throw throwable;
        }
    }

    protected final void expandEntityRef(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            Node node4 = node3.getNextSibling();
            node.insertBefore(node3, node2);
            node3 = node4;
        }
    }

    protected final void namespaceFixUp(ElementImpl elementImpl, AttributeMap attributeMap) {
        String string2;
        String string3;
        String string4;
        String string5;
        Attr attr2;
        if (attributeMap != null) {
            int n = 0;
            while (n < attributeMap.getLength()) {
                attr2 = (Attr)attributeMap.getItem(n);
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged()) {
                    this.fDocument.checkQName(attr2.getPrefix(), attr2.getLocalName());
                }
                if ((string5 = attr2.getNamespaceURI()) != null && string5.equals(NamespaceContext.XMLNS_URI)) {
                    string4 = attr2.getNodeValue();
                    if (string4 == null) {
                        string4 = XMLSymbols.EMPTY_STRING;
                    }
                    if (this.fDocument.errorChecking && string4.equals(NamespaceContext.XMLNS_URI)) {
                        this.fLocator.fRelatedNode = attr2;
                        string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string3, (short)2, "CantBindXMLNS");
                    } else {
                        string2 = attr2.getPrefix();
                        string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
                        string3 = this.fSymbolTable.addSymbol(attr2.getLocalName());
                        if (string2 == XMLSymbols.PREFIX_XMLNS) {
                            if ((string4 = this.fSymbolTable.addSymbol(string4)).length() != 0) {
                                this.fNamespaceContext.declarePrefix(string3, string4);
                            }
                        } else {
                            string4 = this.fSymbolTable.addSymbol(string4);
                            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, string4);
                        }
                    }
                }
                ++n;
            }
        }
        string5 = elementImpl.getNamespaceURI();
        string2 = elementImpl.getPrefix();
        if (string5 != null) {
            string5 = this.fSymbolTable.addSymbol(string5);
            String string6 = string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
            if (this.fNamespaceContext.getURI(string2) != string5) {
                this.addNamespaceDecl(string2, string5, elementImpl);
                this.fLocalNSBinder.declarePrefix(string2, string5);
                this.fNamespaceContext.declarePrefix(string2, string5);
            }
        } else if (elementImpl.getLocalName() == null) {
            if (this.fNamespaceValidation) {
                String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{elementImpl.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string7, (short)3, "NullLocalElementName");
            } else {
                String string8 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{elementImpl.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string8, (short)2, "NullLocalElementName");
            }
        } else {
            string5 = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
            if (string5 != null && string5.length() > 0) {
                this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, elementImpl);
                this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
            }
        }
        if (attributeMap != null) {
            attributeMap.cloneMap(this.fAttributeList);
            int n = 0;
            while (n < this.fAttributeList.size()) {
                attr2 = (Attr)this.fAttributeList.elementAt(n);
                this.fLocator.fRelatedNode = attr2;
                attr2.normalize();
                string4 = attr2.getValue();
                string5 = attr2.getNamespaceURI();
                if (string4 == null) {
                    string4 = XMLSymbols.EMPTY_STRING;
                }
                if (string5 != null) {
                    string2 = attr2.getPrefix();
                    string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
                    this.fSymbolTable.addSymbol(attr2.getLocalName());
                    if (string5 == null || !string5.equals(NamespaceContext.XMLNS_URI)) {
                        String string9;
                        if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                            boolean bl;
                            DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributeMap, attr2, attr2.getValue(), this.fDocument.isXML11Version());
                            if (this.fDocument.isXMLVersionChanged() && !(bl = CoreDocumentImpl.isXMLName(attr2.getNodeName(), this.fDocument.isXML11Version()))) {
                                string9 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attribute", attr2.getNodeName()});
                                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string9, (short)2, "wf-invalid-character-in-node-name");
                            }
                        }
                        ((AttrImpl)attr2).setIdAttribute(false);
                        string5 = this.fSymbolTable.addSymbol(string5);
                        string3 = this.fNamespaceContext.getURI(string2);
                        if (string2 == XMLSymbols.EMPTY_STRING || string3 != string5) {
                            string9 = this.fNamespaceContext.getPrefix(string5);
                            if (string9 != null && string9 != XMLSymbols.EMPTY_STRING) {
                                string2 = string9;
                            } else {
                                if (string2 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string2) != null) {
                                    int n2 = 1;
                                    string2 = this.fSymbolTable.addSymbol(PREFIX + n2++);
                                    while (this.fLocalNSBinder.getURI(string2) != null) {
                                        string2 = this.fSymbolTable.addSymbol(PREFIX + n2++);
                                    }
                                }
                                this.addNamespaceDecl(string2, string5, elementImpl);
                                string4 = this.fSymbolTable.addSymbol(string4);
                                this.fLocalNSBinder.declarePrefix(string2, string4);
                                this.fNamespaceContext.declarePrefix(string2, string5);
                            }
                            attr2.setPrefix(string2);
                        }
                    }
                } else {
                    ((AttrImpl)attr2).setIdAttribute(false);
                    if (attr2.getLocalName() == null) {
                        if (this.fNamespaceValidation) {
                            string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr2.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string3, (short)3, "NullLocalAttrName");
                        } else {
                            string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr2.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string3, (short)2, "NullLocalAttrName");
                        }
                    }
                }
                ++n;
            }
        }
    }

    protected final void addNamespaceDecl(String string2, String string3, ElementImpl elementImpl) {
        if (string2 == XMLSymbols.EMPTY_STRING) {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, string3);
        } else {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + string2, string3);
        }
    }

    public static final void isCDataWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string2, boolean bl) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        char[] cArray = string2.toCharArray();
        char c = cArray.length;
        if (bl) {
            char c2 = '\u0000';
            while (c2 < c) {
                char c3;
                char c4;
                if (XML11Char.isXML11Invalid(c4 = cArray[c2++])) {
                    if (XMLChar.isHighSurrogate(c4) && c2 < c && XMLChar.isLowSurrogate(c3 = cArray[c2++]) && XMLChar.isSupplemental(XMLChar.supplemental(c4, c3))) continue;
                    String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c4, 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c4 != ']' || (c3 = c2) >= c || cArray[c3] != ']') continue;
                while (++c3 < c && cArray[c3] == ']') {
                }
                if (c3 >= c || cArray[c3] != '>') continue;
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string4, (short)2, "wf-invalid-character");
            }
        } else {
            char c5 = '\u0000';
            while (c5 < c) {
                char c6;
                char c7;
                if (XMLChar.isInvalid(c7 = cArray[c5++])) {
                    char c8;
                    if (XMLChar.isHighSurrogate(c7) && c5 < c && XMLChar.isLowSurrogate(c8 = cArray[c5++]) && XMLChar.isSupplemental(XMLChar.supplemental(c7, c8))) continue;
                    String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c7, 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string5, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c7 != ']' || (c6 = c5) >= c || cArray[c6] != ']') continue;
                while (++c6 < c && cArray[c6] == ']') {
                }
                if (c6 >= c || cArray[c6] != '>') continue;
                String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string6, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isXMLCharWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string2, boolean bl) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                char c;
                char c2;
                if (!XML11Char.isXML11Invalid(cArray[n2++]) || XMLChar.isHighSurrogate(c2 = cArray[n2 - 1]) && n2 < n && XMLChar.isLowSurrogate(c = cArray[n2++]) && XMLChar.isSupplemental(XMLChar.supplemental(c2, c))) continue;
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(cArray[n2 - 1], 16)});
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, "wf-invalid-character");
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c;
                char c3;
                if (!XMLChar.isInvalid(cArray[n3++]) || XMLChar.isHighSurrogate(c3 = cArray[n3 - 1]) && n3 < n && XMLChar.isLowSurrogate(c = cArray[n3++]) && XMLChar.isSupplemental(XMLChar.supplemental(c3, c))) continue;
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(cArray[n3 - 1], 16)});
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string4, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isCommentWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string2, boolean bl) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                char c;
                if (XML11Char.isXML11Invalid(c = cArray[n2++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && n2 < n && XMLChar.isLowSurrogate(c2 = cArray[n2++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(cArray[n2 - 1], 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || n2 >= n || cArray[n2] != '-') continue;
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string4, (short)2, "wf-invalid-character");
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c;
                if (XMLChar.isInvalid(c = cArray[n3++])) {
                    char c3;
                    if (XMLChar.isHighSurrogate(c) && n3 < n && XMLChar.isLowSurrogate(c3 = cArray[n3++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c3))) continue;
                    String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(cArray[n3 - 1], 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string5, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || n3 >= n || cArray[n3] != '-') continue;
                String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string6, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isAttrValueWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, NamedNodeMap namedNodeMap, Attr attr2, String string2, boolean bl) {
        if (attr2 instanceof AttrImpl && ((AttrImpl)attr2).hasStringValue()) {
            DOMNormalizer.isXMLCharWF(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string2, bl);
        } else {
            NodeList nodeList = attr2.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 5) {
                    Object object;
                    Document document = attr2.getOwnerDocument();
                    Entity entity = null;
                    if (document != null && (object = document.getDoctype()) != null) {
                        NamedNodeMap namedNodeMap2 = object.getEntities();
                        entity = (Entity)namedNodeMap2.getNamedItemNS("*", node.getNodeName());
                    }
                    if (entity == null) {
                        object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "UndeclaredEntRefInAttrValue", new Object[]{attr2.getNodeName()});
                        DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, (String)object, (short)2, "UndeclaredEntRefInAttrValue");
                    }
                } else {
                    DOMNormalizer.isXMLCharWF(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, node.getNodeValue(), bl);
                }
                ++n;
            }
        }
    }

    public static final void reportDOMError(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string2, short s2, String string3) {
        if (dOMErrorHandler != null) {
            dOMErrorImpl.reset();
            dOMErrorImpl.fMessage = string2;
            dOMErrorImpl.fSeverity = s2;
            dOMErrorImpl.fLocator = dOMLocatorImpl;
            dOMErrorImpl.fType = string3;
            dOMErrorImpl.fRelatedData = dOMLocatorImpl.fRelatedNode;
            if (!dOMErrorHandler.handleError(dOMErrorImpl)) {
                throw abort;
            }
        }
        if (s2 == 3) {
            throw abort;
        }
    }

    protected final void updateQName(Node node, QName qName) {
        String string2 = node.getPrefix();
        String string3 = node.getNamespaceURI();
        String string4 = node.getLocalName();
        qName.prefix = string2 != null && string2.length() != 0 ? this.fSymbolTable.addSymbol(string2) : null;
        qName.localpart = string4 != null ? this.fSymbolTable.addSymbol(string4) : null;
        qName.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qName.uri = string3 != null ? this.fSymbolTable.addSymbol(string3) : null;
    }

    final String normalizeAttributeValue(String string2, Attr attr2) {
        if (!attr2.getSpecified()) {
            return string2;
        }
        int n = string2.length();
        if (this.fNormalizedValue.ch.length < n) {
            this.fNormalizedValue.ch = new char[n];
        }
        this.fNormalizedValue.length = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                bl = true;
            } else if (c == '\r') {
                bl = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int n3 = n2 + 1;
                if (n3 < n && string2.charAt(n3) == '\n') {
                    n2 = n3;
                }
            } else {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
            }
            ++n2;
        }
        if (bl) {
            string2 = this.fNormalizedValue.toString();
            attr2.setValue(string2);
        }
        return string2;
    }

    public void startDocument(XMLLocator xMLLocator, String string2, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
    }

    public void xmlDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
    }

    public void doctypeDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Element element = (Element)this.fCurrentNode;
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fAttrQName);
            Attr attr2 = null;
            attr2 = element.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            AttributePSVI attributePSVI = (AttributePSVI)xMLAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI");
            if (attributePSVI != null) {
                XSTypeDefinition xSTypeDefinition = attributePSVI.getMemberTypeDefinition();
                boolean bl = false;
                if (xSTypeDefinition != null) {
                    bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                } else {
                    xSTypeDefinition = attributePSVI.getTypeDefinition();
                    if (xSTypeDefinition != null) {
                        bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                    }
                }
                if (bl) {
                    ((ElementImpl)element).setIdAttributeNode(attr2, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr2).setPSVI(attributePSVI);
                }
                if ((this.fConfiguration.features & 2) != 0) {
                    boolean bl2 = attr2.getSpecified();
                    attr2.setValue(attributePSVI.getSchemaNormalizedValue());
                    if (!bl2) {
                        ((AttrImpl)attr2).setSpecified(bl2);
                    }
                }
            }
            ++n2;
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
    }

    public void textDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void endGeneralEntity(String string2, Augmentations augmentations) throws XNIException {
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.allWhitespace = true;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        ElementPSVI elementPSVI;
        if (augmentations != null && (elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI")) != null) {
            ElementImpl elementImpl = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            String string2 = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                if (string2 != null) {
                    elementImpl.setTextContent(string2);
                }
            } else {
                String string3 = elementImpl.getTextContent();
                if (string3.length() == 0 && string2 != null) {
                    elementImpl.setTextContent(string2);
                }
            }
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributeMap, CoreDocumentImpl coreDocumentImpl, ElementImpl elementImpl) {
            this.fDocument = coreDocumentImpl;
            this.fAttributes = attributeMap;
            this.fElement = elementImpl;
            if (attributeMap != null) {
                int n = attributeMap.getLength();
                this.fAugmentations.setSize(n);
                int n2 = 0;
                while (n2 < n) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), n2);
                    ++n2;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName qName, String string2, String string3) {
            int n = this.fElement.getXercesAttribute(qName.uri, qName.localpart);
            if (n < 0) {
                AttrImpl attrImpl = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qName.uri, qName.rawname, qName.localpart);
                attrImpl.setNodeValue(string3);
                n = this.fElement.setXercesAttributeNode(attrImpl);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), n);
                attrImpl.setSpecified(false);
            }
            return n;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int n) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String string2) {
            return -1;
        }

        public int getIndex(String string2, String string3) {
            return -1;
        }

        public void setName(int n, QName qName) {
        }

        public void getName(int n, QName qName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(n), qName);
            }
        }

        public String getPrefix(int n) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(n);
                String string2 = node.getPrefix();
                string2 = string2 != null && string2.length() != 0 ? DOMNormalizer.this.fSymbolTable.addSymbol(string2) : null;
                return string2;
            }
            return null;
        }

        public String getURI(int n) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(n);
                String string2 = node.getNamespaceURI();
                string2 = string2 != null ? DOMNormalizer.this.fSymbolTable.addSymbol(string2) : null;
                return string2;
            }
            return null;
        }

        public String getLocalName(int n) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(n);
                String string2 = node.getLocalName();
                string2 = string2 != null ? DOMNormalizer.this.fSymbolTable.addSymbol(string2) : null;
                return string2;
            }
            return null;
        }

        public String getQName(int n) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(n);
                String string2 = DOMNormalizer.this.fSymbolTable.addSymbol(node.getNodeName());
                return string2;
            }
            return null;
        }

        public void setType(int n, String string2) {
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string2) {
            return "CDATA";
        }

        public String getType(String string2, String string3) {
            return "CDATA";
        }

        public void setValue(int n, String string2) {
            if (this.fAttributes != null) {
                AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
                boolean bl = attrImpl.getSpecified();
                attrImpl.setValue(string2);
                attrImpl.setSpecified(bl);
            }
        }

        public String getValue(int n) {
            return this.fAttributes != null ? this.fAttributes.item(n).getNodeValue() : "";
        }

        public String getValue(String string2) {
            return null;
        }

        public String getValue(String string2, String string3) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(string2, string3);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int n, String string2) {
        }

        public String getNonNormalizedValue(int n) {
            return null;
        }

        public void setSpecified(int n, boolean bl) {
            AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
            attrImpl.setSpecified(bl);
        }

        public boolean isSpecified(int n) {
            return ((Attr)this.fAttributes.getItem(n)).getSpecified();
        }

        public Augmentations getAugmentations(int n) {
            return (Augmentations)this.fAugmentations.elementAt(n);
        }

        public Augmentations getAugmentations(String string2, String string3) {
            return null;
        }

        public Augmentations getAugmentations(String string2) {
            return null;
        }

        public void setAugmentations(int n, Augmentations augmentations) {
            this.fAugmentations.setElementAt(augmentations, n);
        }
    }
}

