/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct64
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private long[] values;
    private static final int BITS_PER_VALUE = 64;

    public Direct64(int valueCount) {
        super(valueCount, 64);
        this.values = new long[valueCount];
    }

    public Direct64(DataInput in, int valueCount) throws IOException {
        super(valueCount, 64);
        long[] values2 = new long[valueCount];
        for (int i2 = 0; i2 < valueCount; ++i2) {
            values2[i2] = in.readLong();
        }
        this.values = values2;
    }

    public Direct64(long[] values2) {
        super(values2.length, 64);
        this.values = values2;
    }

    public long get(int index2) {
        assert (index2 >= 0 && index2 < this.size());
        return this.values[index2];
    }

    public void set(int index2, long value2) {
        this.values[index2] = value2;
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.values);
    }

    public void clear() {
        Arrays.fill(this.values, 0L);
    }

    public long[] getArray() {
        return this.values;
    }

    public boolean hasArray() {
        return true;
    }
}

