/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct32
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private int[] values;
    private static final int BITS_PER_VALUE = 32;

    public Direct32(int valueCount) {
        super(valueCount, 32);
        this.values = new int[valueCount];
    }

    public Direct32(DataInput in, int valueCount) throws IOException {
        super(valueCount, 32);
        int[] values2 = new int[valueCount];
        for (int i2 = 0; i2 < valueCount; ++i2) {
            values2[i2] = in.readInt();
        }
        int mod = valueCount % 2;
        if (mod != 0) {
            in.readInt();
        }
        this.values = values2;
    }

    public Direct32(int[] values2) {
        super(values2.length, 32);
        this.values = values2;
    }

    public long get(int index2) {
        assert (index2 >= 0 && index2 < this.size());
        return 0xFFFFFFFFL & (long)this.values[index2];
    }

    public void set(int index2, long value2) {
        this.values[index2] = (int)(value2 & 0xFFFFFFFFFFFFFFFFL);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.values);
    }

    public void clear() {
        Arrays.fill(this.values, 0);
    }

    public int[] getArray() {
        return this.values;
    }

    public boolean hasArray() {
        return true;
    }
}

