/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.StringInterner;

public class SimpleStringInterner
extends StringInterner {
    private final Entry[] cache;
    private final int maxChainLength;

    public SimpleStringInterner(int tableSize, int maxChainLength) {
        this.cache = new Entry[Math.max(1, BitUtil.nextHighestPowerOfTwo(tableSize))];
        this.maxChainLength = Math.max(2, maxChainLength);
    }

    public String intern(String s2) {
        int h = s2.hashCode();
        int slot = h & this.cache.length - 1;
        Entry first2 = this.cache[slot];
        Entry nextToLast = null;
        int chainLength = 0;
        Entry e = first2;
        while (e != null) {
            if (e.hash == h && (e.str == s2 || e.str.compareTo(s2) == 0)) {
                return e.str;
            }
            ++chainLength;
            if (e.next != null) {
                nextToLast = e;
            }
            e = e.next;
        }
        s2 = s2.intern();
        this.cache[slot] = new Entry(s2, h, first2);
        if (chainLength >= this.maxChainLength) {
            nextToLast.next = null;
        }
        return s2;
    }

    private static class Entry {
        private final String str;
        private final int hash;
        private Entry next;

        private Entry(String str, int hash2, Entry next) {
            this.str = str;
            this.hash = hash2;
            this.next = next;
        }
    }
}

