/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSetIterator;

public class OpenBitSet
extends DocIdSet
implements Cloneable,
Serializable,
Bits {
    protected long[] bits;
    protected int wlen;
    private long numBits;

    public OpenBitSet(long numBits) {
        this.numBits = numBits;
        this.bits = new long[OpenBitSet.bits2words(numBits)];
        this.wlen = this.bits.length;
    }

    public OpenBitSet() {
        this(64L);
    }

    public OpenBitSet(long[] bits, int numWords) {
        this.bits = bits;
        this.wlen = numWords;
        this.numBits = this.wlen * 64;
    }

    public DocIdSetIterator iterator() {
        return new OpenBitSetIterator(this.bits, this.wlen);
    }

    public boolean isCacheable() {
        return true;
    }

    public long capacity() {
        return this.bits.length << 6;
    }

    public long size() {
        return this.capacity();
    }

    public int length() {
        return this.bits.length << 6;
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public long[] getBits() {
        return this.bits;
    }

    public void setBits(long[] bits) {
        this.bits = bits;
    }

    public int getNumWords() {
        return this.wlen;
    }

    public void setNumWords(int nWords) {
        this.wlen = nWords;
    }

    public boolean get(int index2) {
        int i2 = index2 >> 6;
        if (i2 >= this.bits.length) {
            return false;
        }
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i2] & bitmask) != 0L;
    }

    public boolean fastGet(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int i2 = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i2] & bitmask) != 0L;
    }

    public boolean get(long index2) {
        int i2 = (int)(index2 >> 6);
        if (i2 >= this.bits.length) {
            return false;
        }
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i2] & bitmask) != 0L;
    }

    public boolean fastGet(long index2) {
        assert (index2 >= 0L && index2 < this.numBits);
        int i2 = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i2] & bitmask) != 0L;
    }

    public int getBit(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int i2 = index2 >> 6;
        int bit = index2 & 0x3F;
        return (int)(this.bits[i2] >>> bit) & 1;
    }

    public void set(long index2) {
        int wordNum = this.expandingWordNum(index2);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void fastSet(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void fastSet(long index2) {
        assert (index2 >= 0L && index2 < this.numBits);
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void set(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    protected int expandingWordNum(long index2) {
        int wordNum = (int)(index2 >> 6);
        if (wordNum >= this.wlen) {
            this.ensureCapacity(index2 + 1L);
            this.wlen = wordNum + 1;
        }
        assert ((this.numBits = Math.max(this.numBits, index2 + 1L)) >= 0L);
        return wordNum;
    }

    public void fastClear(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void fastClear(long index2) {
        assert (index2 >= 0L && index2 < this.numBits);
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(long index2) {
        int wordNum = (int)(index2 >> 6);
        if (wordNum >= this.wlen) {
            return;
        }
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public boolean getAndSet(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public boolean getAndSet(long index2) {
        assert (index2 >= 0L && index2 < this.numBits);
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public void fastFlip(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void fastFlip(long index2) {
        assert (index2 >= 0L && index2 < this.numBits);
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void flip(long index2) {
        int wordNum = this.expandingWordNum(index2);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public boolean flipAndGet(int index2) {
        assert (index2 >= 0 && (long)index2 < this.numBits);
        int wordNum = index2 >> 6;
        int bit = index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public boolean flipAndGet(long index2) {
        assert (index2 >= 0L && index2 < this.numBits);
        int wordNum = (int)(index2 >> 6);
        int bit = (int)index2 & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public void flip(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i2 = startWord + 1; i2 < endWord; ++i2) {
            this.bits[i2] = this.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.wlen);
    }

    public static long intersectionCount(OpenBitSet a, OpenBitSet b) {
        return BitUtil.pop_intersect(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
    }

    public static long unionCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_union(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen < b.wlen) {
            tot += BitUtil.pop_array(b.bits, a.wlen, b.wlen - a.wlen);
        } else if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public static long andNotCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_andnot(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public static long xorCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_xor(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen < b.wlen) {
            tot += BitUtil.pop_array(b.bits, a.wlen, b.wlen - a.wlen);
        } else if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public int nextSetBit(int index2) {
        int i2 = index2 >> 6;
        if (i2 >= this.wlen) {
            return -1;
        }
        int subIndex = index2 & 0x3F;
        long word = this.bits[i2] >> subIndex;
        if (word != 0L) {
            return (i2 << 6) + subIndex + BitUtil.ntz(word);
        }
        while (++i2 < this.wlen) {
            word = this.bits[i2];
            if (word == 0L) continue;
            return (i2 << 6) + BitUtil.ntz(word);
        }
        return -1;
    }

    public long nextSetBit(long index2) {
        int i2 = (int)(index2 >>> 6);
        if (i2 >= this.wlen) {
            return -1L;
        }
        int subIndex = (int)index2 & 0x3F;
        long word = this.bits[i2] >>> subIndex;
        if (word != 0L) {
            return ((long)i2 << 6) + (long)(subIndex + BitUtil.ntz(word));
        }
        while (++i2 < this.wlen) {
            word = this.bits[i2];
            if (word == 0L) continue;
            return ((long)i2 << 6) + (long)BitUtil.ntz(word);
        }
        return -1L;
    }

    public int prevSetBit(int index2) {
        long word;
        int subIndex;
        int i2 = index2 >> 6;
        if (i2 >= this.wlen) {
            i2 = this.wlen - 1;
            if (i2 < 0) {
                return -1;
            }
            subIndex = 63;
            word = this.bits[i2];
        } else {
            if (i2 < 0) {
                return -1;
            }
            subIndex = index2 & 0x3F;
            word = this.bits[i2] << 63 - subIndex;
        }
        if (word != 0L) {
            return (i2 << 6) + subIndex - Long.numberOfLeadingZeros(word);
        }
        while (--i2 >= 0) {
            word = this.bits[i2];
            if (word == 0L) continue;
            return (i2 << 6) + 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    public long prevSetBit(long index2) {
        long word;
        int subIndex;
        int i2 = (int)(index2 >> 6);
        if (i2 >= this.wlen) {
            i2 = this.wlen - 1;
            if (i2 < 0) {
                return -1L;
            }
            subIndex = 63;
            word = this.bits[i2];
        } else {
            if (i2 < 0) {
                return -1L;
            }
            subIndex = (int)index2 & 0x3F;
            word = this.bits[i2] << 63 - subIndex;
        }
        if (word != 0L) {
            return ((long)i2 << 6) + (long)subIndex - (long)Long.numberOfLeadingZeros(word);
        }
        while (--i2 >= 0) {
            word = this.bits[i2];
            if (word == 0L) continue;
            return ((long)i2 << 6) + 63L - (long)Long.numberOfLeadingZeros(word);
        }
        return -1L;
    }

    public Object clone() {
        try {
            OpenBitSet obs = (OpenBitSet)super.clone();
            obs.bits = (long[])obs.bits.clone();
            return obs;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void intersect(OpenBitSet other) {
        int newLen = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos2 = newLen;
        while (--pos2 >= 0) {
            int n = pos2;
            thisArr[n] = thisArr[n] & otherArr[pos2];
        }
        if (this.wlen > newLen) {
            Arrays.fill(this.bits, newLen, this.wlen, 0L);
        }
        this.wlen = newLen;
    }

    public void union(OpenBitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        assert ((this.numBits = Math.max(other.numBits, this.numBits)) >= 0L);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos2 = Math.min(this.wlen, other.wlen);
        while (--pos2 >= 0) {
            int n = pos2;
            thisArr[n] = thisArr[n] | otherArr[pos2];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void remove(OpenBitSet other) {
        int idx = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--idx >= 0) {
            int n = idx;
            thisArr[n] = thisArr[n] & (otherArr[idx] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void xor(OpenBitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        assert ((this.numBits = Math.max(other.numBits, this.numBits)) >= 0L);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos2 = Math.min(this.wlen, other.wlen);
        while (--pos2 >= 0) {
            int n = pos2;
            thisArr[n] = thisArr[n] ^ otherArr[pos2];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void and(OpenBitSet other) {
        this.intersect(other);
    }

    public void or(OpenBitSet other) {
        this.union(other);
    }

    public void andNot(OpenBitSet other) {
        this.remove(other);
    }

    public boolean intersects(OpenBitSet other) {
        int pos2 = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--pos2 >= 0) {
            if ((thisArr[pos2] & otherArr[pos2]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacityWords(int numWords) {
        if (this.bits.length < numWords) {
            this.bits = ArrayUtil.grow(this.bits, numWords);
        }
    }

    public void ensureCapacity(long numBits) {
        this.ensureCapacityWords(OpenBitSet.bits2words(numBits));
    }

    public void trimTrailingZeros() {
        int idx;
        for (idx = this.wlen - 1; idx >= 0 && this.bits[idx] == 0L; --idx) {
        }
        this.wlen = idx + 1;
    }

    public static int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    public boolean equals(Object o) {
        int i2;
        OpenBitSet a;
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenBitSet)) {
            return false;
        }
        OpenBitSet b = (OpenBitSet)o;
        if (b.wlen > this.wlen) {
            a = b;
            b = this;
        } else {
            a = this;
        }
        for (i2 = a.wlen - 1; i2 >= b.wlen; --i2) {
            if (a.bits[i2] == 0L) continue;
            return false;
        }
        for (i2 = b.wlen - 1; i2 >= 0; --i2) {
            if (a.bits[i2] == b.bits[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h = 0L;
        int i2 = this.bits.length;
        while (--i2 >= 0) {
            h ^= this.bits[i2];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }
}

