/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;

public class ByteBufferFile {
    final ByteBufferDirectory dir;
    final int bufferSize;
    final List<ByteBuffer> buffers;
    long length;
    volatile long lastModified = System.currentTimeMillis();
    final AtomicInteger refCount;
    long sizeInBytes;

    public ByteBufferFile(ByteBufferDirectory dir, int bufferSize) {
        this.dir = dir;
        this.bufferSize = bufferSize;
        this.buffers = new ArrayList<ByteBuffer>();
        this.refCount = new AtomicInteger(1);
    }

    ByteBufferFile(ByteBufferFile file2) {
        this.dir = file2.dir;
        this.bufferSize = file2.bufferSize;
        this.buffers = file2.buffers;
        this.length = file2.length;
        this.lastModified = file2.lastModified;
        this.refCount = file2.refCount;
        this.sizeInBytes = file2.sizeInBytes;
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    long sizeInBytes() {
        return this.sizeInBytes;
    }

    ByteBuffer getBuffer(int index2) {
        return this.buffers.get(index2);
    }

    int numBuffers() {
        return this.buffers.size();
    }

    void delete() {
        this.decRef();
    }

    void incRef() {
        this.refCount.incrementAndGet();
    }

    void decRef() {
        if (this.refCount.decrementAndGet() == 0) {
            this.length = 0L;
            for (ByteBuffer buffer : this.buffers) {
                this.dir.releaseBuffer(buffer);
            }
            this.buffers.clear();
            this.sizeInBytes = 0L;
        }
    }
}

