/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NRTCachingDirectory
extends Directory {
    private final RAMDirectory cache = new RAMDirectory();
    private final Directory delegate;
    private final long maxMergeSizeBytes;
    private final long maxCachedBytes;
    private static final boolean VERBOSE = false;
    private final ConcurrentHashMap<Thread, MergePolicy.OneMerge> merges = new ConcurrentHashMap();
    private final Object uncacheLock = new Object();

    public NRTCachingDirectory(Directory delegate2, double maxMergeSizeMB, double maxCachedMB) {
        this.delegate = delegate2;
        this.maxMergeSizeBytes = (long)(maxMergeSizeMB * 1024.0 * 1024.0);
        this.maxCachedBytes = (long)(maxCachedMB * 1024.0 * 1024.0);
    }

    @Override
    public LockFactory getLockFactory() {
        return this.delegate.getLockFactory();
    }

    @Override
    public void setLockFactory(LockFactory lf) throws IOException {
        this.delegate.setLockFactory(lf);
    }

    @Override
    public String getLockID() {
        return this.delegate.getLockID();
    }

    @Override
    public Lock makeLock(String name2) {
        return this.delegate.makeLock(name2);
    }

    @Override
    public void clearLock(String name2) throws IOException {
        this.delegate.clearLock(name2);
    }

    @Override
    public String toString() {
        return "NRTCachingDirectory(" + this.delegate + "; maxCacheMB=" + (double)(this.maxCachedBytes / 1024L) / 1024.0 + " maxMergeSizeMB=" + (double)(this.maxMergeSizeBytes / 1024L) / 1024.0 + ")";
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        HashSet<String> files;
        block4: {
            files = new HashSet<String>();
            for (String f : this.cache.listAll()) {
                files.add(f);
            }
            try {
                for (String f : this.delegate.listAll()) {
                    files.add(f);
                }
            }
            catch (NoSuchDirectoryException ex) {
                if (!files.isEmpty()) break block4;
                throw ex;
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public long sizeInBytes() {
        return this.cache.sizeInBytes();
    }

    @Override
    public synchronized boolean fileExists(String name2) throws IOException {
        return this.cache.fileExists(name2) || this.delegate.fileExists(name2);
    }

    @Override
    public synchronized long fileModified(String name2) throws IOException {
        if (this.cache.fileExists(name2)) {
            return this.cache.fileModified(name2);
        }
        return this.delegate.fileModified(name2);
    }

    @Override
    @Deprecated
    public synchronized void touchFile(String name2) throws IOException {
        if (this.cache.fileExists(name2)) {
            this.cache.touchFile(name2);
        } else {
            this.delegate.touchFile(name2);
        }
    }

    @Override
    public synchronized void deleteFile(String name2) throws IOException {
        if (this.cache.fileExists(name2)) {
            assert (!this.delegate.fileExists(name2)) : "name=" + name2;
            this.cache.deleteFile(name2);
        } else {
            this.delegate.deleteFile(name2);
        }
    }

    @Override
    public synchronized long fileLength(String name2) throws IOException {
        if (this.cache.fileExists(name2)) {
            return this.cache.fileLength(name2);
        }
        return this.delegate.fileLength(name2);
    }

    public String[] listCachedFiles() {
        return this.cache.listAll();
    }

    @Override
    public IndexOutput createOutput(String name2) throws IOException {
        if (this.doCacheWrite(name2)) {
            try {
                this.delegate.deleteFile(name2);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.cache.createOutput(name2);
        }
        try {
            this.cache.deleteFile(name2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.delegate.createOutput(name2);
    }

    @Override
    public void sync(Collection<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            this.unCache(fileName);
        }
        this.delegate.sync(fileNames);
    }

    @Override
    public synchronized IndexInput openInput(String name2) throws IOException {
        if (this.cache.fileExists(name2)) {
            return this.cache.openInput(name2);
        }
        return this.delegate.openInput(name2);
    }

    @Override
    public synchronized IndexInput openInput(String name2, int bufferSize) throws IOException {
        if (this.cache.fileExists(name2)) {
            return this.cache.openInput(name2, bufferSize);
        }
        return this.delegate.openInput(name2, bufferSize);
    }

    @Override
    public void close() throws IOException {
        for (String fileName : this.cache.listAll()) {
            this.unCache(fileName);
        }
        this.cache.close();
        this.delegate.close();
    }

    public MergeScheduler getMergeScheduler() {
        return new ConcurrentMergeScheduler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doMerge(MergePolicy.OneMerge merge2) throws IOException {
                try {
                    NRTCachingDirectory.this.merges.put(Thread.currentThread(), merge2);
                    super.doMerge(merge2);
                    Object var3_2 = null;
                    NRTCachingDirectory.this.merges.remove(Thread.currentThread());
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    NRTCachingDirectory.this.merges.remove(Thread.currentThread());
                    throw throwable;
                }
            }
        };
    }

    protected boolean doCacheWrite(String name2) {
        MergePolicy.OneMerge merge2 = this.merges.get(Thread.currentThread());
        return !name2.equals("segments.gen") && (merge2 == null || merge2.estimatedMergeBytes <= this.maxMergeSizeBytes) && this.cache.sizeInBytes() <= this.maxCachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCache(String fileName) throws IOException {
        Object object = this.uncacheLock;
        synchronized (object) {
            if (!this.cache.fileExists(fileName)) {
                return;
            }
            if (this.delegate.fileExists(fileName)) {
                throw new IOException("cannot uncache file=\"" + fileName + "\": it was separately also created in the delegate directory");
            }
            IndexOutput out = this.delegate.createOutput(fileName);
            IndexInput in = null;
            try {
                in = this.cache.openInput(fileName);
                in.copyBytes(out, in.length());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                IOUtils.close(in, out);
                throw throwable;
            }
            IOUtils.close(in, out);
            NRTCachingDirectory nRTCachingDirectory = this;
            synchronized (nRTCachingDirectory) {
                this.cache.deleteFile(fileName);
            }
        }
    }
}

