/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexInput;

public class ChecksumIndexInput
extends IndexInput {
    IndexInput main;
    Checksum digest;

    public ChecksumIndexInput(IndexInput main2) {
        super("ChecksumIndexInput(" + main2 + ")");
        this.main = main2;
        this.digest = new CRC32();
    }

    public byte readByte() throws IOException {
        byte b = this.main.readByte();
        this.digest.update(b);
        return b;
    }

    public void readBytes(byte[] b, int offset2, int len) throws IOException {
        this.main.readBytes(b, offset2, len);
        this.digest.update(b, offset2, len);
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    public void close() throws IOException {
        this.main.close();
    }

    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    public void seek(long pos2) {
        throw new UnsupportedOperationException();
    }

    public long length() {
        return this.main.length();
    }
}

