/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.regex;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.regexp.RE;
import org.apache.regexp.REProgram;

public class JakartaRegexpCapabilities
implements RegexCapabilities {
    private RE regexp;
    private static Field prefixField;
    private static Method getPrefixMethod;
    private int flags = 0;
    public static final int FLAG_MATCH_NORMAL = 0;
    public static final int FLAG_MATCH_CASEINDEPENDENT = 1;

    public JakartaRegexpCapabilities() {
    }

    public JakartaRegexpCapabilities(int flags) {
        this.flags = flags;
    }

    public void compile(String pattern) {
        this.regexp = new RE(pattern, this.flags);
    }

    public boolean match(String string2) {
        return this.regexp.match(string2);
    }

    public String prefix() {
        try {
            char[] prefix;
            if (getPrefixMethod != null) {
                prefix = (char[])getPrefixMethod.invoke((Object)this.regexp.getProgram(), new Object[0]);
            } else if (prefixField != null) {
                prefix = (char[])prefixField.get(this.regexp.getProgram());
            } else {
                return null;
            }
            return prefix == null ? null : new String(prefix);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JakartaRegexpCapabilities that = (JakartaRegexpCapabilities)o;
        return !(this.regexp != null ? !this.regexp.equals(that.regexp) : that.regexp != null);
    }

    public int hashCode() {
        return this.regexp != null ? this.regexp.hashCode() : 0;
    }

    static {
        try {
            getPrefixMethod = REProgram.class.getMethod("getPrefix", new Class[0]);
        }
        catch (Exception e) {
            getPrefixMethod = null;
        }
        try {
            prefixField = REProgram.class.getDeclaredField("prefix");
            prefixField.setAccessible(true);
        }
        catch (Exception e) {
            prefixField = null;
        }
    }
}

