/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.util.CollectionUtil;

public final class TokenStreamFromTermPositionVector
extends TokenStream {
    private final List<Token> positionedTokens = new ArrayList<Token>();
    private Iterator<Token> tokensAtCurrentPosition;
    private CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private PositionIncrementAttribute positionIncrementAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
    private static final Comparator<Token> tokenComparator = new Comparator<Token>(){

        @Override
        public int compare(Token o1, Token o2) {
            return o1.getPositionIncrement() - o2.getPositionIncrement();
        }
    };

    public TokenStreamFromTermPositionVector(TermPositionVector termPositionVector) {
        String[] terms = termPositionVector.getTerms();
        for (int i2 = 0; i2 < terms.length; ++i2) {
            TermVectorOffsetInfo[] offsets2 = termPositionVector.getOffsets(i2);
            int[] termPositions = termPositionVector.getTermPositions(i2);
            for (int j = 0; j < termPositions.length; ++j) {
                Token token;
                if (offsets2 != null) {
                    token = new Token(terms[i2].toCharArray(), 0, terms[i2].length(), offsets2[j].getStartOffset(), offsets2[j].getEndOffset());
                } else {
                    token = new Token();
                    token.setEmpty().append(terms[i2]);
                }
                token.setPositionIncrement(termPositions[j]);
                this.positionedTokens.add(token);
            }
        }
        CollectionUtil.mergeSort(this.positionedTokens, tokenComparator);
        int lastPosition = -1;
        for (Token token : this.positionedTokens) {
            int thisPosition = token.getPositionIncrement();
            token.setPositionIncrement(thisPosition - lastPosition);
            lastPosition = thisPosition;
        }
        this.tokensAtCurrentPosition = this.positionedTokens.iterator();
    }

    public boolean incrementToken() throws IOException {
        if (this.tokensAtCurrentPosition.hasNext()) {
            Token next = this.tokensAtCurrentPosition.next();
            this.clearAttributes();
            this.termAttribute.setEmpty().append(next);
            this.positionIncrementAttribute.setPositionIncrement(next.getPositionIncrement());
            this.offsetAttribute.setOffset(next.startOffset(), next.endOffset());
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        this.tokensAtCurrentPosition = this.positionedTokens.iterator();
    }
}

