/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;

public class CustomScoreProvider {
    protected final IndexReader reader;

    public CustomScoreProvider(IndexReader reader) {
        this.reader = reader;
    }

    public float customScore(int doc, float subQueryScore, float[] valSrcScores) throws IOException {
        if (valSrcScores.length == 1) {
            return this.customScore(doc, subQueryScore, valSrcScores[0]);
        }
        if (valSrcScores.length == 0) {
            return this.customScore(doc, subQueryScore, 1.0f);
        }
        float score = subQueryScore;
        for (int i2 = 0; i2 < valSrcScores.length; ++i2) {
            score *= valSrcScores[i2];
        }
        return score;
    }

    public float customScore(int doc, float subQueryScore, float valSrcScore) throws IOException {
        return subQueryScore * valSrcScore;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation[] valSrcExpls) throws IOException {
        if (valSrcExpls.length == 1) {
            return this.customExplain(doc, subQueryExpl, valSrcExpls[0]);
        }
        if (valSrcExpls.length == 0) {
            return subQueryExpl;
        }
        float valSrcScore = 1.0f;
        for (int i2 = 0; i2 < valSrcExpls.length; ++i2) {
            valSrcScore *= valSrcExpls[i2].getValue();
        }
        Explanation exp2 = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp2.addDetail(subQueryExpl);
        for (int i3 = 0; i3 < valSrcExpls.length; ++i3) {
            exp2.addDetail(valSrcExpls[i3]);
        }
        return exp2;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation valSrcExpl) throws IOException {
        float valSrcScore = 1.0f;
        if (valSrcExpl != null) {
            valSrcScore *= valSrcExpl.getValue();
        }
        Explanation exp2 = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp2.addDetail(subQueryExpl);
        exp2.addDetail(valSrcExpl);
        return exp2;
    }
}

