/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class TermsFilter
extends Filter {
    Set<Term> terms = new TreeSet<Term>();

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FixedBitSet result2 = new FixedBitSet(reader.maxDoc());
        TermDocs td = reader.termDocs();
        try {
            for (Term term : this.terms) {
                td.seek(term);
                while (td.next()) {
                    result2.set(td.doc());
                }
            }
        }
        finally {
            td.close();
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TermsFilter test2 = (TermsFilter)obj;
        return this.terms == test2.terms || this.terms != null && ((Object)this.terms).equals(test2.terms);
    }

    public int hashCode() {
        int hash2 = 9;
        for (Term term : this.terms) {
            hash2 = 31 * hash2 + term.hashCode();
        }
        return hash2;
    }
}

