/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldDocSortedHitQueue
extends PriorityQueue<FieldDoc> {
    volatile SortField[] fields = null;
    volatile Collator[] collators = null;
    volatile FieldComparator<?>[] comparators = null;

    FieldDocSortedHitQueue(int size2) {
        this.initialize(size2);
    }

    void setFields(SortField[] fields2) throws IOException {
        this.fields = fields2;
        this.collators = this.hasCollators(fields2);
        this.comparators = new FieldComparator[fields2.length];
        for (int fieldIDX = 0; fieldIDX < fields2.length; ++fieldIDX) {
            this.comparators[fieldIDX] = fields2[fieldIDX].getComparator(1, fieldIDX);
        }
    }

    SortField[] getFields() {
        return this.fields;
    }

    private Collator[] hasCollators(SortField[] fields2) {
        if (fields2 == null) {
            return null;
        }
        Collator[] ret = new Collator[fields2.length];
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            Locale locale = fields2[i2].getLocale();
            if (locale == null) continue;
            ret[i2] = Collator.getInstance(locale);
        }
        return ret;
    }

    @Override
    protected final boolean lessThan(FieldDoc docA, FieldDoc docB) {
        int n = this.fields.length;
        int c = 0;
        for (int i2 = 0; i2 < n && c == 0; ++i2) {
            int type2 = this.fields[i2].getType();
            if (type2 == 3) {
                String s1 = (String)docA.fields[i2];
                String s2 = (String)docB.fields[i2];
                c = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : (this.fields[i2].getLocale() == null ? s1.compareTo(s2) : this.collators[i2].compare(s1, s2)));
            } else {
                FieldComparator<?> comp = this.comparators[i2];
                c = comp.compareValues(docA.fields[i2], docB.fields[i2]);
            }
            if (!this.fields[i2].getReverse()) continue;
            c = -c;
        }
        if (c == 0) {
            return docA.doc > docB.doc;
        }
        return c > 0;
    }
}

