/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldCacheDocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class FieldCacheTermsFilter
extends Filter {
    private String field;
    private String[] terms;

    public FieldCacheTermsFilter(String field2, String ... terms) {
        this.field = field2;
        this.terms = terms;
    }

    public FieldCache getFieldCache() {
        return FieldCache.DEFAULT;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final FieldCache.StringIndex fcsi = this.getFieldCache().getStringIndex(reader, this.field);
        final FixedBitSet bits = new FixedBitSet(fcsi.lookup.length);
        for (int i2 = 0; i2 < this.terms.length; ++i2) {
            int termNumber = fcsi.binarySearchLookup(this.terms[i2]);
            if (termNumber <= 0) continue;
            bits.set(termNumber);
        }
        return new FieldCacheDocIdSet(reader){

            protected final boolean matchDoc(int doc) {
                return bits.get(fcsi.order[doc]);
            }
        };
    }
}

