/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCacheImpl;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;

public interface FieldCache {
    public static final int STRING_INDEX = -1;
    public static final FieldCache DEFAULT = new FieldCacheImpl();
    public static final ByteParser DEFAULT_BYTE_PARSER = new ByteParser(){

        public byte parseByte(String value2) {
            return Byte.parseByte(value2);
        }

        protected Object readResolve() {
            return DEFAULT_BYTE_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_BYTE_PARSER";
        }
    };
    public static final ShortParser DEFAULT_SHORT_PARSER = new ShortParser(){

        public short parseShort(String value2) {
            return Short.parseShort(value2);
        }

        protected Object readResolve() {
            return DEFAULT_SHORT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_SHORT_PARSER";
        }
    };
    public static final IntParser DEFAULT_INT_PARSER = new IntParser(){

        public int parseInt(String value2) {
            return Integer.parseInt(value2);
        }

        protected Object readResolve() {
            return DEFAULT_INT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_INT_PARSER";
        }
    };
    public static final FloatParser DEFAULT_FLOAT_PARSER = new FloatParser(){

        public float parseFloat(String value2) {
            return Float.parseFloat(value2);
        }

        protected Object readResolve() {
            return DEFAULT_FLOAT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_FLOAT_PARSER";
        }
    };
    public static final LongParser DEFAULT_LONG_PARSER = new LongParser(){

        public long parseLong(String value2) {
            return Long.parseLong(value2);
        }

        protected Object readResolve() {
            return DEFAULT_LONG_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_LONG_PARSER";
        }
    };
    public static final DoubleParser DEFAULT_DOUBLE_PARSER = new DoubleParser(){

        public double parseDouble(String value2) {
            return Double.parseDouble(value2);
        }

        protected Object readResolve() {
            return DEFAULT_DOUBLE_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".DEFAULT_DOUBLE_PARSER";
        }
    };
    public static final IntParser NUMERIC_UTILS_INT_PARSER = new IntParser(){

        public int parseInt(String val) {
            int shift2 = val.charAt(0) - 96;
            if (shift2 > 0 && shift2 <= 31) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.prefixCodedToInt(val);
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_INT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_INT_PARSER";
        }
    };
    public static final FloatParser NUMERIC_UTILS_FLOAT_PARSER = new FloatParser(){

        public float parseFloat(String val) {
            int shift2 = val.charAt(0) - 96;
            if (shift2 > 0 && shift2 <= 31) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(val));
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_FLOAT_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_FLOAT_PARSER";
        }
    };
    public static final LongParser NUMERIC_UTILS_LONG_PARSER = new LongParser(){

        public long parseLong(String val) {
            int shift2 = val.charAt(0) - 32;
            if (shift2 > 0 && shift2 <= 63) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.prefixCodedToLong(val);
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_LONG_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_LONG_PARSER";
        }
    };
    public static final DoubleParser NUMERIC_UTILS_DOUBLE_PARSER = new DoubleParser(){

        public double parseDouble(String val) {
            int shift2 = val.charAt(0) - 32;
            if (shift2 > 0 && shift2 <= 63) {
                throw new FieldCacheImpl.StopFillCacheException();
            }
            return NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(val));
        }

        protected Object readResolve() {
            return NUMERIC_UTILS_DOUBLE_PARSER;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_DOUBLE_PARSER";
        }
    };

    public Bits getDocsWithField(IndexReader var1, String var2) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2, ByteParser var3) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2, ByteParser var3, boolean var4) throws IOException;

    public short[] getShorts(IndexReader var1, String var2) throws IOException;

    public short[] getShorts(IndexReader var1, String var2, ShortParser var3) throws IOException;

    public short[] getShorts(IndexReader var1, String var2, ShortParser var3, boolean var4) throws IOException;

    public int[] getInts(IndexReader var1, String var2) throws IOException;

    public int[] getInts(IndexReader var1, String var2, IntParser var3) throws IOException;

    public int[] getInts(IndexReader var1, String var2, IntParser var3, boolean var4) throws IOException;

    public float[] getFloats(IndexReader var1, String var2) throws IOException;

    public float[] getFloats(IndexReader var1, String var2, FloatParser var3) throws IOException;

    public float[] getFloats(IndexReader var1, String var2, FloatParser var3, boolean var4) throws IOException;

    public long[] getLongs(IndexReader var1, String var2) throws IOException;

    public long[] getLongs(IndexReader var1, String var2, LongParser var3) throws IOException;

    public long[] getLongs(IndexReader var1, String var2, LongParser var3, boolean var4) throws IOException;

    public double[] getDoubles(IndexReader var1, String var2) throws IOException;

    public double[] getDoubles(IndexReader var1, String var2, DoubleParser var3) throws IOException;

    public double[] getDoubles(IndexReader var1, String var2, DoubleParser var3, boolean var4) throws IOException;

    public String[] getStrings(IndexReader var1, String var2) throws IOException;

    public StringIndex getStringIndex(IndexReader var1, String var2) throws IOException;

    public CacheEntry[] getCacheEntries();

    public void purgeAllCaches();

    public void purge(IndexReader var1);

    public void setInfoStream(PrintStream var1);

    public PrintStream getInfoStream();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CacheEntry {
        private String size = null;

        public abstract Object getReaderKey();

        public abstract String getFieldName();

        public abstract Class<?> getCacheType();

        public abstract Object getCustom();

        public abstract Object getValue();

        protected final void setEstimatedSize(String size2) {
            this.size = size2;
        }

        public void estimateSize() {
            long size2 = RamUsageEstimator.sizeOf(this.getValue());
            this.setEstimatedSize(RamUsageEstimator.humanReadableUnits(size2));
        }

        public final String getEstimatedSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("'").append(this.getReaderKey()).append("'=>");
            b.append("'").append(this.getFieldName()).append("',");
            b.append(this.getCacheType()).append(",").append(this.getCustom());
            b.append("=>").append(this.getValue().getClass().getName()).append("#");
            b.append(System.identityHashCode(this.getValue()));
            String s2 = this.getEstimatedSize();
            if (null != s2) {
                b.append(" (size =~ ").append(s2).append(')');
            }
            return b.toString();
        }
    }

    public static interface DoubleParser
    extends Parser {
        public double parseDouble(String var1);
    }

    public static interface LongParser
    extends Parser {
        public long parseLong(String var1);
    }

    public static interface FloatParser
    extends Parser {
        public float parseFloat(String var1);
    }

    public static interface IntParser
    extends Parser {
        public int parseInt(String var1);
    }

    public static interface ShortParser
    extends Parser {
        public short parseShort(String var1);
    }

    public static interface ByteParser
    extends Parser {
        public byte parseByte(String var1);
    }

    public static interface Parser
    extends Serializable {
    }

    public static class StringIndex {
        public final String[] lookup;
        public final int[] order;

        public int binarySearchLookup(String key2) {
            if (key2 == null) {
                return 0;
            }
            int low = 1;
            int high = this.lookup.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp2 = this.lookup[mid].compareTo(key2);
                if (cmp2 < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp2 > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public StringIndex(int[] values2, String[] lookup) {
            this.order = values2;
            this.lookup = lookup;
        }
    }

    public static final class CreationPlaceholder {
        Object value;
    }
}

