/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class ExactPhraseScorer
extends Scorer {
    private final byte[] norms;
    private final float value;
    private static final int SCORE_CACHE_SIZE = 32;
    private final float[] scoreCache = new float[32];
    private final int endMinus1;
    private static final int CHUNK = 4096;
    private int gen;
    private final int[] counts = new int[4096];
    private final int[] gens = new int[4096];
    boolean noDocs;
    private final ChunkState[] chunkStates;
    private int docID = -1;
    private int freq;

    ExactPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postings, Similarity similarity, byte[] norms) throws IOException {
        super(similarity, weight);
        int i2;
        this.norms = norms;
        this.value = weight.getValue();
        this.chunkStates = new ChunkState[postings.length];
        this.endMinus1 = postings.length - 1;
        for (i2 = 0; i2 < postings.length; ++i2) {
            boolean useAdvance = postings[i2].docFreq > 5 * postings[0].docFreq;
            this.chunkStates[i2] = new ChunkState(postings[i2].postings, -postings[i2].position, useAdvance);
            if (i2 <= 0 || postings[i2].postings.next()) continue;
            this.noDocs = true;
            return;
        }
        for (i2 = 0; i2 < 32; ++i2) {
            this.scoreCache[i2] = this.getSimilarity().tf((float)i2) * this.value;
        }
    }

    public int nextDoc() throws IOException {
        while (true) {
            int i2;
            if (!this.chunkStates[0].posEnum.next()) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            int doc = this.chunkStates[0].posEnum.doc();
            for (i2 = 1; i2 < this.chunkStates.length; ++i2) {
                ChunkState cs = this.chunkStates[i2];
                int doc2 = cs.posEnum.doc();
                if (cs.useAdvance) {
                    if (doc2 < doc) {
                        if (!cs.posEnum.skipTo(doc)) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        doc2 = cs.posEnum.doc();
                    }
                } else {
                    int iter = 0;
                    while (doc2 < doc) {
                        if (++iter == 50) {
                            if (!cs.posEnum.skipTo(doc)) {
                                this.docID = Integer.MAX_VALUE;
                                return this.docID;
                            }
                            doc2 = cs.posEnum.doc();
                            break;
                        }
                        if (cs.posEnum.next()) {
                            doc2 = cs.posEnum.doc();
                            continue;
                        }
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                }
                if (doc2 > doc) break;
            }
            if (i2 != this.chunkStates.length) continue;
            this.docID = doc;
            this.freq = this.phraseFreq();
            if (this.freq != 0) break;
        }
        return this.docID;
    }

    public int advance(int target) throws IOException {
        if (!this.chunkStates[0].posEnum.skipTo(target)) {
            this.docID = Integer.MAX_VALUE;
            return this.docID;
        }
        int doc = this.chunkStates[0].posEnum.doc();
        while (true) {
            int i2;
            for (i2 = 1; i2 < this.chunkStates.length; ++i2) {
                int doc2 = this.chunkStates[i2].posEnum.doc();
                if (doc2 < doc) {
                    if (!this.chunkStates[i2].posEnum.skipTo(doc)) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    doc2 = this.chunkStates[i2].posEnum.doc();
                }
                if (doc2 > doc) break;
            }
            if (i2 == this.chunkStates.length) {
                this.docID = doc;
                this.freq = this.phraseFreq();
                if (this.freq != 0) {
                    return this.docID;
                }
            }
            if (!this.chunkStates[0].posEnum.next()) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            doc = this.chunkStates[0].posEnum.doc();
        }
    }

    public String toString() {
        return "ExactPhraseScorer(" + this.weight + ")";
    }

    public float freq() {
        return this.freq;
    }

    public int docID() {
        return this.docID;
    }

    public float score() throws IOException {
        float raw = this.freq < 32 ? this.scoreCache[this.freq] : this.getSimilarity().tf((float)this.freq) * this.value;
        return this.norms == null ? raw : raw * this.getSimilarity().decodeNormValue(this.norms[this.docID]);
    }

    private int phraseFreq() throws IOException {
        this.freq = 0;
        for (int i2 = 0; i2 < this.chunkStates.length; ++i2) {
            ChunkState cs = this.chunkStates[i2];
            cs.posLimit = cs.posEnum.freq();
            cs.pos = cs.offset + cs.posEnum.nextPosition();
            cs.posUpto = 1;
            cs.lastPos = -1;
        }
        int chunkStart = 0;
        int chunkEnd = 4096;
        boolean end2 = false;
        while (!end2) {
            ++this.gen;
            if (this.gen == 0) {
                Arrays.fill(this.gens, 0);
                ++this.gen;
            }
            ChunkState cs = this.chunkStates[0];
            while (cs.pos < chunkEnd) {
                if (cs.pos > cs.lastPos) {
                    cs.lastPos = cs.pos;
                    int posIndex = cs.pos - chunkStart;
                    this.counts[posIndex] = 1;
                    assert (this.gens[posIndex] != this.gen);
                    this.gens[posIndex] = this.gen;
                }
                if (cs.posUpto == cs.posLimit) {
                    end2 = true;
                    break;
                }
                ++cs.posUpto;
                cs.pos = cs.offset + cs.posEnum.nextPosition();
            }
            boolean any = true;
            for (int t = 1; t < this.endMinus1; ++t) {
                ChunkState cs2 = this.chunkStates[t];
                any = false;
                while (cs2.pos < chunkEnd) {
                    if (cs2.pos > cs2.lastPos) {
                        cs2.lastPos = cs2.pos;
                        int posIndex = cs2.pos - chunkStart;
                        if (posIndex >= 0 && this.gens[posIndex] == this.gen && this.counts[posIndex] == t) {
                            int n = posIndex;
                            this.counts[n] = this.counts[n] + 1;
                            any = true;
                        }
                    }
                    if (cs2.posUpto == cs2.posLimit) {
                        end2 = true;
                        break;
                    }
                    ++cs2.posUpto;
                    cs2.pos = cs2.offset + cs2.posEnum.nextPosition();
                }
                if (!any) break;
            }
            if (!any) {
                chunkStart += 4096;
                chunkEnd += 4096;
                continue;
            }
            ChunkState cs3 = this.chunkStates[this.endMinus1];
            while (cs3.pos < chunkEnd) {
                if (cs3.pos > cs3.lastPos) {
                    cs3.lastPos = cs3.pos;
                    int posIndex = cs3.pos - chunkStart;
                    if (posIndex >= 0 && this.gens[posIndex] == this.gen && this.counts[posIndex] == this.endMinus1) {
                        ++this.freq;
                    }
                }
                if (cs3.posUpto == cs3.posLimit) {
                    end2 = true;
                    break;
                }
                ++cs3.posUpto;
                cs3.pos = cs3.offset + cs3.posEnum.nextPosition();
            }
            chunkStart += 4096;
            chunkEnd += 4096;
        }
        return this.freq;
    }

    private static final class ChunkState {
        final TermPositions posEnum;
        final int offset;
        final boolean useAdvance;
        int posUpto;
        int posLimit;
        int pos;
        int lastPos;

        public ChunkState(TermPositions posEnum, int offset2, boolean useAdvance) {
            this.posEnum = posEnum;
            this.offset = offset2;
            this.useAdvance = useAdvance;
        }
    }
}

