/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class DisjunctionScorer
extends Scorer {
    protected final Scorer[] subScorers;
    protected int numScorers;

    protected DisjunctionScorer(Similarity similarity, Weight weight, Scorer[] subScorers, int numScorers) {
        super(similarity, weight);
        this.subScorers = subScorers;
        this.numScorers = numScorers;
        this.heapify();
    }

    protected final void heapify() {
        for (int i2 = (this.numScorers >> 1) - 1; i2 >= 0; --i2) {
            this.heapAdjust(i2);
        }
    }

    protected final void heapAdjust(int root) {
        Scorer scorer = this.subScorers[root];
        int doc = scorer.docID();
        int i2 = root;
        while (i2 <= (this.numScorers >> 1) - 1) {
            int lchild = (i2 << 1) + 1;
            Scorer lscorer = this.subScorers[lchild];
            int ldoc = lscorer.docID();
            int rdoc = Integer.MAX_VALUE;
            int rchild = (i2 << 1) + 2;
            Scorer rscorer = null;
            if (rchild < this.numScorers) {
                rscorer = this.subScorers[rchild];
                rdoc = rscorer.docID();
            }
            if (ldoc < doc) {
                if (rdoc < ldoc) {
                    this.subScorers[i2] = rscorer;
                    this.subScorers[rchild] = scorer;
                    i2 = rchild;
                    continue;
                }
                this.subScorers[i2] = lscorer;
                this.subScorers[lchild] = scorer;
                i2 = lchild;
                continue;
            }
            if (rdoc < doc) {
                this.subScorers[i2] = rscorer;
                this.subScorers[rchild] = scorer;
                i2 = rchild;
                continue;
            }
            return;
        }
    }

    protected final void heapRemoveRoot() {
        if (this.numScorers == 1) {
            this.subScorers[0] = null;
            this.numScorers = 0;
        } else {
            this.subScorers[0] = this.subScorers[this.numScorers - 1];
            this.subScorers[this.numScorers - 1] = null;
            --this.numScorers;
            this.heapAdjust(0);
        }
    }
}

