/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;

public class ChainedFilter
extends Filter {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int ANDNOT = 2;
    public static final int XOR = 3;
    public static int DEFAULT = 0;
    private Filter[] chain = null;
    private int[] logicArray;
    private int logic = -1;

    public ChainedFilter(Filter[] chain) {
        this.chain = chain;
    }

    public ChainedFilter(Filter[] chain, int[] logicArray) {
        this.chain = chain;
        this.logicArray = logicArray;
    }

    public ChainedFilter(Filter[] chain, int logic) {
        this.chain = chain;
        this.logic = logic;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        int[] index2 = new int[]{0};
        if (this.logic != -1) {
            return this.getDocIdSet(reader, this.logic, index2);
        }
        if (this.logicArray != null) {
            return this.getDocIdSet(reader, this.logicArray, index2);
        }
        return this.getDocIdSet(reader, DEFAULT, index2);
    }

    private DocIdSetIterator getDISI(Filter filter, IndexReader reader) throws IOException {
        DocIdSet docIdSet = filter.getDocIdSet(reader);
        if (docIdSet == null) {
            return DocIdSet.EMPTY_DOCIDSET.iterator();
        }
        DocIdSetIterator iter = docIdSet.iterator();
        if (iter == null) {
            return DocIdSet.EMPTY_DOCIDSET.iterator();
        }
        return iter;
    }

    private OpenBitSetDISI initialResult(IndexReader reader, int logic, int[] index2) throws IOException {
        OpenBitSetDISI result2;
        if (logic == 1) {
            result2 = new OpenBitSetDISI(this.getDISI(this.chain[index2[0]], reader), reader.maxDoc());
            index2[0] = index2[0] + 1;
        } else if (logic == 2) {
            result2 = new OpenBitSetDISI(this.getDISI(this.chain[index2[0]], reader), reader.maxDoc());
            result2.flip(0L, reader.maxDoc());
            index2[0] = index2[0] + 1;
        } else {
            result2 = new OpenBitSetDISI(reader.maxDoc());
        }
        return result2;
    }

    @Deprecated
    protected final DocIdSet finalResult(OpenBitSetDISI result2, int maxDocs) {
        return result2;
    }

    private DocIdSet getDocIdSet(IndexReader reader, int logic, int[] index2) throws IOException {
        OpenBitSetDISI result2 = this.initialResult(reader, logic, index2);
        while (index2[0] < this.chain.length) {
            this.doChain(result2, logic, this.chain[index2[0]].getDocIdSet(reader));
            index2[0] = index2[0] + 1;
        }
        return this.finalResult(result2, reader.maxDoc());
    }

    private DocIdSet getDocIdSet(IndexReader reader, int[] logic, int[] index2) throws IOException {
        if (logic.length != this.chain.length) {
            throw new IllegalArgumentException("Invalid number of elements in logic array");
        }
        OpenBitSetDISI result2 = this.initialResult(reader, logic[0], index2);
        while (index2[0] < this.chain.length) {
            this.doChain(result2, logic[index2[0]], this.chain[index2[0]].getDocIdSet(reader));
            index2[0] = index2[0] + 1;
        }
        return this.finalResult(result2, reader.maxDoc());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChainedFilter: [");
        for (int i2 = 0; i2 < this.chain.length; ++i2) {
            sb.append(this.chain[i2]);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void doChain(OpenBitSetDISI result2, int logic, DocIdSet dis) throws IOException {
        if (dis instanceof OpenBitSet) {
            switch (logic) {
                case 0: {
                    result2.or((OpenBitSet)dis);
                    break;
                }
                case 1: {
                    result2.and((OpenBitSet)dis);
                    break;
                }
                case 2: {
                    result2.andNot((OpenBitSet)dis);
                    break;
                }
                case 3: {
                    result2.xor((OpenBitSet)dis);
                    break;
                }
                default: {
                    this.doChain(result2, DEFAULT, dis);
                    break;
                }
            }
        } else {
            DocIdSetIterator disi;
            if (dis == null) {
                disi = DocIdSet.EMPTY_DOCIDSET.iterator();
            } else {
                disi = dis.iterator();
                if (disi == null) {
                    disi = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
            }
            switch (logic) {
                case 0: {
                    result2.inPlaceOr(disi);
                    break;
                }
                case 1: {
                    result2.inPlaceAnd(disi);
                    break;
                }
                case 2: {
                    result2.inPlaceNot(disi);
                    break;
                }
                case 3: {
                    result2.inPlaceXor(disi);
                    break;
                }
                default: {
                    this.doChain(result2, DEFAULT, dis);
                }
            }
        }
    }
}

