/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ExistsFieldQueryExtension;
import org.apache.lucene.queryParser.FieldQueryExtension;
import org.apache.lucene.queryParser.MissingFieldQueryExtension;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MapperQueryParser
extends QueryParser {
    public static final ImmutableMap<String, FieldQueryExtension> fieldQueryExtensions = ImmutableMap.builder().put("_exists_", new ExistsFieldQueryExtension()).put("_missing_", (ExistsFieldQueryExtension)((Object)new MissingFieldQueryExtension())).build();
    private final QueryParseContext parseContext;
    private QueryParserSettings settings;
    private Analyzer quoteAnalyzer;
    private boolean forcedAnalyzer;
    private boolean forcedQuoteAnalyzer;
    private FieldMapper currentMapper;
    private boolean analyzeWildcard;
    private String quoteFieldSuffix;

    public MapperQueryParser(QueryParseContext parseContext) {
        super(Lucene.QUERYPARSER_VERSION, null, null);
        this.parseContext = parseContext;
    }

    public MapperQueryParser(QueryParserSettings settings, QueryParseContext parseContext) {
        super(Lucene.QUERYPARSER_VERSION, settings.defaultField(), settings.defaultAnalyzer());
        this.parseContext = parseContext;
        this.reset(settings);
    }

    public void reset(QueryParserSettings settings) {
        this.settings = settings;
        this.field = settings.defaultField();
        if (settings.fields() != null) {
            this.field = settings.fields.size() == 1 ? settings.fields().get(0) : null;
        }
        this.forcedAnalyzer = settings.forcedAnalyzer() != null;
        Analyzer analyzer = this.analyzer = this.forcedAnalyzer ? settings.forcedAnalyzer() : settings.defaultAnalyzer();
        if (settings.forcedQuoteAnalyzer() != null) {
            this.forcedQuoteAnalyzer = true;
            this.quoteAnalyzer = settings.forcedQuoteAnalyzer();
        } else if (this.forcedAnalyzer) {
            this.forcedQuoteAnalyzer = true;
            this.quoteAnalyzer = settings.forcedAnalyzer();
        } else {
            this.forcedAnalyzer = false;
            this.quoteAnalyzer = settings.defaultQuoteAnalyzer();
        }
        this.quoteFieldSuffix = settings.quoteFieldSuffix();
        this.setMultiTermRewriteMethod(settings.rewriteMethod());
        this.setEnablePositionIncrements(settings.enablePositionIncrements());
        this.setAutoGeneratePhraseQueries(settings.autoGeneratePhraseQueries());
        this.setAllowLeadingWildcard(settings.allowLeadingWildcard());
        this.setLowercaseExpandedTerms(settings.lowercaseExpandedTerms());
        this.setPhraseSlop(settings.phraseSlop());
        this.setDefaultOperator(settings.defaultOperator());
        this.setFuzzyMinSim(settings.fuzzyMinSim());
        this.setFuzzyPrefixLength(settings.fuzzyPrefixLength());
        this.analyzeWildcard = settings.analyzeWildcard();
    }

    @Override
    protected Query newTermQuery(Term term) {
        Query termQuery;
        if (this.currentMapper != null && (termQuery = this.currentMapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return super.newTermQuery(term);
    }

    @Override
    protected Query newMatchAllDocsQuery() {
        return Queries.MATCH_ALL_QUERY;
    }

    @Override
    public Query getFieldQuery(String field2, String queryText, boolean quoted) throws ParseException {
        FieldQueryExtension fieldQueryExtension = fieldQueryExtensions.get(field2);
        if (fieldQueryExtension != null) {
            return fieldQueryExtension.query(this.parseContext, queryText);
        }
        Collection<String> fields2 = this.extractMultiFields(field2);
        if (fields2 != null) {
            if (fields2.size() == 1) {
                return this.getFieldQuerySingle(fields2.iterator().next(), queryText, quoted);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields2) {
                    Query q = this.getFieldQuerySingle(mField, queryText, quoted);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields2) {
                Query q = this.getFieldQuerySingle(mField, queryText, true);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getFieldQuerySingle(field2, queryText, quoted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query getFieldQuerySingle(String field2, String queryText, boolean quoted) throws ParseException {
        if (!quoted && queryText.length() > 1) {
            if (queryText.charAt(0) == '>') {
                if (queryText.length() <= 2) return this.getRangeQuerySingle(field2, queryText.substring(1), null, false, true);
                if (queryText.charAt(1) != '=') return this.getRangeQuerySingle(field2, queryText.substring(1), null, false, true);
                return this.getRangeQuerySingle(field2, queryText.substring(2), null, true, true);
            }
            if (queryText.charAt(0) == '<') {
                if (queryText.length() <= 2) return this.getRangeQuerySingle(field2, null, queryText.substring(1), true, false);
                if (queryText.charAt(1) != '=') return this.getRangeQuerySingle(field2, null, queryText.substring(1), true, false);
                return this.getRangeQuerySingle(field2, null, queryText.substring(2), true, true);
            }
        }
        this.currentMapper = null;
        Analyzer oldAnalyzer = this.analyzer;
        try {
            MapperService.SmartNameFieldMappers fieldMappers = null;
            if (quoted) {
                this.analyzer = this.quoteAnalyzer;
                if (this.quoteFieldSuffix != null) {
                    fieldMappers = this.parseContext.smartFieldMappers(field2 + this.quoteFieldSuffix);
                }
            }
            if (fieldMappers == null) {
                fieldMappers = this.parseContext.smartFieldMappers(field2);
            }
            if (fieldMappers != null) {
                if (quoted) {
                    if (!this.forcedQuoteAnalyzer) {
                        this.analyzer = fieldMappers.searchQuoteAnalyzer();
                    }
                } else if (!this.forcedAnalyzer) {
                    this.analyzer = fieldMappers.searchAnalyzer();
                }
                this.currentMapper = fieldMappers.fieldMappers().mapper();
                if (this.currentMapper != null) {
                    Query query;
                    block25: {
                        query = null;
                        if (this.currentMapper.useFieldQueryWithQueryString()) {
                            try {
                                if (fieldMappers.explicitTypeInNameWithDocMapper()) {
                                    String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{fieldMappers.docMapper().type()});
                                    try {
                                        query = this.currentMapper.fieldQuery(queryText, this.parseContext);
                                        break block25;
                                    }
                                    finally {
                                        QueryParseContext.setTypes(previousTypes);
                                    }
                                }
                                query = this.currentMapper.fieldQuery(queryText, this.parseContext);
                            }
                            catch (RuntimeException e) {
                                if (!this.settings.lenient()) throw e;
                                Query query2 = null;
                                this.analyzer = oldAnalyzer;
                                return query2;
                            }
                        }
                    }
                    if (query == null) {
                        query = super.getFieldQuery(this.currentMapper.names().indexName(), queryText, quoted);
                    }
                    Query query3 = QueryParsers.wrapSmartNameQuery(query, fieldMappers, this.parseContext);
                    return query3;
                }
            }
            Query query = super.getFieldQuery(field2, queryText, quoted);
            return query;
        }
        finally {
            this.analyzer = oldAnalyzer;
        }
    }

    @Override
    protected Query getFieldQuery(String field2, String queryText, int slop) throws ParseException {
        Collection<String> fields2 = this.extractMultiFields(field2);
        if (fields2 != null) {
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields2) {
                    Query q = super.getFieldQuery(mField, queryText, slop);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(field2, q);
                    this.applySlop(q, slop);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields2) {
                Query q = super.getFieldQuery(mField, queryText, slop);
                if (q == null) continue;
                this.applyBoost(field2, q);
                this.applySlop(q, slop);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFieldQuery(field2, queryText, slop);
    }

    @Override
    protected Query getRangeQuery(String field2, String part1, String part2, boolean inclusive) throws ParseException {
        Collection<String> fields2;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        if ((fields2 = this.extractMultiFields(field2)) != null) {
            if (fields2.size() == 1) {
                return this.getRangeQuerySingle(fields2.iterator().next(), part1, part2, inclusive, inclusive);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields2) {
                    Query q = this.getRangeQuerySingle(mField, part1, part2, inclusive, inclusive);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields2) {
                Query q = this.getRangeQuerySingle(mField, part1, part2, inclusive, inclusive);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getRangeQuerySingle(field2, part1, part2, inclusive, inclusive);
    }

    private Query getRangeQuerySingle(String field2, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        this.currentMapper = null;
        MapperService.SmartNameFieldMappers fieldMappers = this.parseContext.smartFieldMappers(field2);
        if (fieldMappers != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                try {
                    Query rangeQuery = this.currentMapper.rangeQuery(part1, part2, startInclusive, endInclusive, this.parseContext);
                    return QueryParsers.wrapSmartNameQuery(rangeQuery, fieldMappers, this.parseContext);
                }
                catch (RuntimeException e) {
                    if (this.settings.lenient()) {
                        return null;
                    }
                    throw e;
                }
            }
        }
        return this.newRangeQuery(field2, part1, part2, startInclusive || endInclusive);
    }

    @Override
    protected Query getFuzzyQuery(String field2, String termStr, float minSimilarity) throws ParseException {
        Collection<String> fields2 = this.extractMultiFields(field2);
        if (fields2 != null) {
            if (fields2.size() == 1) {
                return this.getFuzzyQuerySingle(fields2.iterator().next(), termStr, minSimilarity);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields2) {
                    Query q = this.getFuzzyQuerySingle(mField, termStr, minSimilarity);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields2) {
                Query q = this.getFuzzyQuerySingle(mField, termStr, minSimilarity);
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getFuzzyQuerySingle(field2, termStr, minSimilarity);
    }

    private Query getFuzzyQuerySingle(String field2, String termStr, float minSimilarity) throws ParseException {
        this.currentMapper = null;
        MapperService.SmartNameFieldMappers fieldMappers = this.parseContext.smartFieldMappers(field2);
        if (fieldMappers != null) {
            this.currentMapper = fieldMappers.fieldMappers().mapper();
            if (this.currentMapper != null) {
                try {
                    Query fuzzyQuery = this.currentMapper.fuzzyQuery(termStr, minSimilarity, this.fuzzyPrefixLength, this.settings.fuzzyMaxExpansions());
                    return QueryParsers.wrapSmartNameQuery(fuzzyQuery, fieldMappers, this.parseContext);
                }
                catch (RuntimeException e) {
                    if (this.settings.lenient()) {
                        return null;
                    }
                    throw e;
                }
            }
        }
        return super.getFuzzyQuery(field2, termStr, minSimilarity);
    }

    @Override
    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        FuzzyQuery query = new FuzzyQuery(term, minimumSimilarity, prefixLength, this.settings.fuzzyMaxExpansions());
        QueryParsers.setRewriteMethod((MultiTermQuery)query, this.settings.fuzzyRewriteMethod());
        return query;
    }

    @Override
    protected Query getPrefixQuery(String field2, String termStr) throws ParseException {
        Collection<String> fields2 = this.extractMultiFields(field2);
        if (fields2 != null) {
            if (fields2.size() == 1) {
                return this.getPrefixQuerySingle(fields2.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields2) {
                    Query q = this.getPrefixQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields2) {
                Query q = this.getPrefixQuerySingle(mField, termStr);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getPrefixQuerySingle(field2, termStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getPrefixQuerySingle(String field2, String termStr) throws ParseException {
        this.currentMapper = null;
        Analyzer oldAnalyzer = this.analyzer;
        try {
            MapperService.SmartNameFieldMappers fieldMappers = this.parseContext.smartFieldMappers(field2);
            if (fieldMappers != null) {
                if (!this.forcedAnalyzer) {
                    this.analyzer = fieldMappers.searchAnalyzer();
                }
                this.currentMapper = fieldMappers.fieldMappers().mapper();
                if (this.currentMapper != null) {
                    Query query = null;
                    if (this.currentMapper.useFieldQueryWithQueryString()) {
                        if (fieldMappers.explicitTypeInNameWithDocMapper()) {
                            String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{fieldMappers.docMapper().type()});
                            try {
                                query = this.currentMapper.prefixQuery(termStr, this.multiTermRewriteMethod, this.parseContext);
                            }
                            finally {
                                QueryParseContext.setTypes(previousTypes);
                            }
                        } else {
                            query = this.currentMapper.prefixQuery(termStr, this.multiTermRewriteMethod, this.parseContext);
                        }
                    }
                    if (query == null) {
                        query = this.getPossiblyAnalyzedPrefixQuery(this.currentMapper.names().indexName(), termStr);
                    }
                    Query query2 = QueryParsers.wrapSmartNameQuery(query, fieldMappers, this.parseContext);
                    return query2;
                }
            }
            Query query = this.getPossiblyAnalyzedPrefixQuery(field2, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.analyzer = oldAnalyzer;
        }
    }

    private Query getPossiblyAnalyzedPrefixQuery(String field2, String termStr) throws ParseException {
        TokenStream source2;
        if (!this.analyzeWildcard) {
            return super.getPrefixQuery(field2, termStr);
        }
        try {
            source2 = this.getAnalyzer().reusableTokenStream(field2, new StringReader(termStr));
        }
        catch (IOException e) {
            return super.getPrefixQuery(field2, termStr);
        }
        ArrayList<String> tlist = new ArrayList<String>();
        CharTermAttribute termAtt = source2.addAttribute(CharTermAttribute.class);
        while (true) {
            try {
                if (!source2.incrementToken()) {
                }
            }
            catch (IOException e) {}
            break;
            tlist.add(termAtt.toString());
        }
        try {
            source2.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (tlist.size() == 1) {
            return super.getPrefixQuery(field2, (String)tlist.get(0));
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String token : tlist) {
            clauses.add(new BooleanClause(super.getPrefixQuery(field2, token), BooleanClause.Occur.SHOULD));
        }
        return this.getBooleanQuery(clauses, true);
    }

    @Override
    protected Query getWildcardQuery(String field2, String termStr) throws ParseException {
        if (termStr.equals("*") && ("*".equals(field2) || Objects.equal(field2, this.field))) {
            String actualField = field2;
            if (actualField == null) {
                actualField = this.field;
            }
            if (actualField == null) {
                return this.newMatchAllDocsQuery();
            }
            if ("*".equals(actualField) || "_all".equals(actualField)) {
                return this.newMatchAllDocsQuery();
            }
            return fieldQueryExtensions.get("_exists_").query(this.parseContext, actualField);
        }
        Collection<String> fields2 = this.extractMultiFields(field2);
        if (fields2 != null) {
            if (fields2.size() == 1) {
                return this.getWildcardQuerySingle(fields2.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.settings.tieBreaker());
                boolean added = false;
                for (String mField : fields2) {
                    Query q = this.getWildcardQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    this.applyBoost(mField, q);
                    disMaxQuery.add(q);
                }
                if (!added) {
                    return null;
                }
                return disMaxQuery;
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields2) {
                Query q = this.getWildcardQuerySingle(mField, termStr);
                if (q == null) continue;
                this.applyBoost(mField, q);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return this.getWildcardQuerySingle(field2, termStr);
    }

    private Query getWildcardQuerySingle(String field2, String termStr) throws ParseException {
        String indexedNameField = field2;
        this.currentMapper = null;
        Analyzer oldAnalyzer = this.analyzer;
        try {
            MapperService.SmartNameFieldMappers fieldMappers = this.parseContext.smartFieldMappers(field2);
            if (fieldMappers != null) {
                if (!this.forcedAnalyzer) {
                    this.analyzer = fieldMappers.searchAnalyzer();
                }
                this.currentMapper = fieldMappers.fieldMappers().mapper();
                if (this.currentMapper != null) {
                    indexedNameField = this.currentMapper.names().indexName();
                }
                Query query = QueryParsers.wrapSmartNameQuery(this.getPossiblyAnalyzedWildcardQuery(indexedNameField, termStr), fieldMappers, this.parseContext);
                return query;
            }
            Query query = this.getPossiblyAnalyzedWildcardQuery(indexedNameField, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.analyzer = oldAnalyzer;
        }
    }

    private Query getPossiblyAnalyzedWildcardQuery(String field2, String termStr) throws ParseException {
        if (!this.analyzeWildcard) {
            return super.getWildcardQuery(field2, termStr);
        }
        boolean isWithinToken = !termStr.startsWith("?") && !termStr.startsWith("*");
        StringBuilder aggStr = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        for (int i2 = 0; i2 < termStr.length(); ++i2) {
            char c = termStr.charAt(i2);
            if (c == '?' || c == '*') {
                if (isWithinToken) {
                    try {
                        TokenStream source2 = this.getAnalyzer().reusableTokenStream(field2, new FastStringReader(tmp.toString()));
                        CharTermAttribute termAtt = source2.addAttribute(CharTermAttribute.class);
                        if (source2.incrementToken()) {
                            String term = termAtt.toString();
                            if (term.length() == 0) {
                                aggStr.append((CharSequence)tmp);
                            } else {
                                aggStr.append(term);
                            }
                        } else {
                            aggStr.append((CharSequence)tmp);
                        }
                        source2.close();
                    }
                    catch (IOException e) {
                        aggStr.append((CharSequence)tmp);
                    }
                    tmp.setLength(0);
                }
                isWithinToken = false;
                aggStr.append(c);
                continue;
            }
            tmp.append(c);
            isWithinToken = true;
        }
        if (isWithinToken) {
            try {
                TokenStream source3 = this.getAnalyzer().reusableTokenStream(field2, new FastStringReader(tmp.toString()));
                CharTermAttribute termAtt = source3.addAttribute(CharTermAttribute.class);
                if (source3.incrementToken()) {
                    String term = termAtt.toString();
                    if (term.length() == 0) {
                        aggStr.append((CharSequence)tmp);
                    } else {
                        aggStr.append(term);
                    }
                } else {
                    aggStr.append((CharSequence)tmp);
                }
                source3.close();
            }
            catch (IOException e) {
                aggStr.append((CharSequence)tmp);
            }
        }
        return super.getWildcardQuery(field2, aggStr.toString());
    }

    @Override
    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        Query q = super.getBooleanQuery(clauses, disableCoord);
        if (q == null) {
            return null;
        }
        return Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(q));
    }

    private void applyBoost(String field2, Query q) {
        if (this.settings.boosts() != null) {
            float boost = this.settings.boosts().get(field2);
            q.setBoost(boost);
        }
    }

    private void applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            ((PhraseQuery)q).setSlop(slop);
        } else if (q instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)q).setSlop(slop);
        }
    }

    private Collection<String> extractMultiFields(String field2) {
        Collection<String> fields2 = null;
        if (field2 != null) {
            if (Regex.isSimpleMatchPattern(field2)) {
                fields2 = this.parseContext.mapperService().simpleMatchToIndexNames(field2);
            }
        } else {
            fields2 = this.settings.fields();
        }
        return fields2;
    }
}

