/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TrackingMergeScheduler;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class TrackingConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    protected final ESLogger logger;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();

    public TrackingConcurrentMergeScheduler(ESLogger logger) {
        this.logger = logger;
    }

    public long totalMerges() {
        return this.totalMerges.count();
    }

    public long totalMergeTime() {
        return this.totalMerges.sum();
    }

    public long totalMergeNumDocs() {
        return this.totalMergesNumDocs.count();
    }

    public long totalMergeSizeInBytes() {
        return this.totalMergesSizeInBytes.count();
    }

    public long currentMerges() {
        return this.currentMerges.count();
    }

    public long currentMergesNumDocs() {
        return this.currentMergesNumDocs.count();
    }

    public long currentMergesSizeInBytes() {
        return this.currentMergesSizeInBytes.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMerge(MergePolicy.OneMerge merge2) throws IOException {
        int totalNumDocs = merge2.totalNumDocs();
        long totalSizeInBytes = merge2.estimatedMergeBytes;
        long time = System.currentTimeMillis();
        this.currentMerges.inc();
        this.currentMergesNumDocs.inc(totalNumDocs);
        this.currentMergesSizeInBytes.inc(totalSizeInBytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", merge2.info == null ? "_na_" : merge2.info.name, merge2.segments.size(), totalNumDocs, new ByteSizeValue(totalSizeInBytes), new ByteSizeValue(merge2.estimatedMergeBytes));
        }
        try {
            TrackingMergeScheduler.setCurrentMerge(merge2);
            super.doMerge(merge2);
        }
        catch (Throwable throwable) {
            TrackingMergeScheduler.removeCurrentMerge();
            long took = System.currentTimeMillis() - time;
            this.currentMerges.dec();
            this.currentMergesNumDocs.dec(totalNumDocs);
            this.currentMergesSizeInBytes.dec(totalSizeInBytes);
            this.totalMergesNumDocs.inc(totalNumDocs);
            this.totalMergesSizeInBytes.inc(totalSizeInBytes);
            this.totalMerges.inc(took);
            if (took > 20000L) {
                this.logger.debug("merge [{}] done, took [{}]", merge2.info == null ? "_na_" : merge2.info.name, TimeValue.timeValueMillis(took));
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("merge [{}] done, took [{}]", merge2.info == null ? "_na_" : merge2.info.name, TimeValue.timeValueMillis(took));
            }
            throw throwable;
        }
        TrackingMergeScheduler.removeCurrentMerge();
        long took = System.currentTimeMillis() - time;
        this.currentMerges.dec();
        this.currentMergesNumDocs.dec(totalNumDocs);
        this.currentMergesSizeInBytes.dec(totalSizeInBytes);
        this.totalMergesNumDocs.inc(totalNumDocs);
        this.totalMergesSizeInBytes.inc(totalSizeInBytes);
        this.totalMerges.inc(took);
        if (took > 20000L) {
            this.logger.debug("merge [{}] done, took [{}]", merge2.info == null ? "_na_" : merge2.info.name, TimeValue.timeValueMillis(took));
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] done, took [{}]", merge2.info == null ? "_na_" : merge2.info.name, TimeValue.timeValueMillis(took));
        }
    }
}

