/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.util.ArrayUtil;

class ParallelPostingsArray {
    static final int BYTES_PER_POSTING = 12;
    final int size;
    final int[] textStarts;
    final int[] intStarts;
    final int[] byteStarts;

    ParallelPostingsArray(int size2) {
        this.size = size2;
        this.textStarts = new int[size2];
        this.intStarts = new int[size2];
        this.byteStarts = new int[size2];
    }

    int bytesPerPosting() {
        return 12;
    }

    ParallelPostingsArray newInstance(int size2) {
        return new ParallelPostingsArray(size2);
    }

    final ParallelPostingsArray grow() {
        int newSize = ArrayUtil.oversize(this.size + 1, this.bytesPerPosting());
        ParallelPostingsArray newArray = this.newInstance(newSize);
        this.copyTo(newArray, this.size);
        return newArray;
    }

    void copyTo(ParallelPostingsArray toArray, int numToCopy) {
        System.arraycopy(this.textStarts, 0, toArray.textStarts, 0, numToCopy);
        System.arraycopy(this.intStarts, 0, toArray.intStarts, 0, numToCopy);
        System.arraycopy(this.byteStarts, 0, toArray.byteStarts, 0, numToCopy);
    }
}

