/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.NormsWriterPerField;
import org.apache.lucene.index.NormsWriterPerThread;
import org.apache.lucene.index.SegmentNorms;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NormsWriter
extends InvertedDocEndConsumer {
    private final byte defaultNorm = Similarity.getDefault().encodeNormValue(1.0f);
    private FieldInfos fieldInfos;

    NormsWriter() {
    }

    @Override
    public InvertedDocEndConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new NormsWriterPerThread(docInverterPerThread, this);
    }

    @Override
    public void abort() {
    }

    void files(Collection<String> files) {
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush(Map<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> threadsAndFields, SegmentWriteState state2) throws IOException {
        IndexOutput normsOut;
        block21: {
            HashMap<FieldInfo, ArrayList<NormsWriterPerField>> byField = new HashMap<FieldInfo, ArrayList<NormsWriterPerField>>();
            for (Map.Entry<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> entry : threadsAndFields.entrySet()) {
                Collection<InvertedDocEndConsumerPerField> fields2 = entry.getValue();
                Iterator<InvertedDocEndConsumerPerField> fieldsIt = fields2.iterator();
                while (fieldsIt.hasNext()) {
                    NormsWriterPerField perField = (NormsWriterPerField)fieldsIt.next();
                    if (perField.upto > 0) {
                        ArrayList<NormsWriterPerField> l = (ArrayList<NormsWriterPerField>)byField.get(perField.fieldInfo);
                        if (l == null) {
                            l = new ArrayList<NormsWriterPerField>();
                            byField.put(perField.fieldInfo, l);
                        }
                        l.add(perField);
                        continue;
                    }
                    fieldsIt.remove();
                }
            }
            String normsFileName = IndexFileNames.segmentFileName(state2.segmentName, "nrm");
            normsOut = state2.directory.createOutput(normsFileName);
            boolean success2 = false;
            try {
                normsOut.writeBytes(SegmentNorms.NORMS_HEADER, 0, SegmentNorms.NORMS_HEADER.length);
                int numField = this.fieldInfos.size();
                int normCount = 0;
                for (int fieldNumber = 0; fieldNumber < numField; ++fieldNumber) {
                    int upto2;
                    FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
                    List toMerge = (List)byField.get(fieldInfo);
                    if (toMerge != null) {
                        int numFields = toMerge.size();
                        ++normCount;
                        NormsWriterPerField[] fields3 = new NormsWriterPerField[numFields];
                        int[] uptos = new int[numFields];
                        for (int j = 0; j < numFields; ++j) {
                            fields3[j] = (NormsWriterPerField)toMerge.get(j);
                        }
                        int numLeft = numFields;
                        while (numLeft > 0) {
                            assert (uptos[0] < fields3[0].docIDs.length) : " uptos[0]=" + uptos[0] + " len=" + fields3[0].docIDs.length;
                            int minLoc = 0;
                            int minDocID = fields3[0].docIDs[uptos[0]];
                            for (int j = 1; j < numLeft; ++j) {
                                int docID = fields3[j].docIDs[uptos[j]];
                                if (docID >= minDocID) continue;
                                minDocID = docID;
                                minLoc = j;
                            }
                            assert (minDocID < state2.numDocs);
                            while (upto2 < minDocID) {
                                normsOut.writeByte(this.defaultNorm);
                                ++upto2;
                            }
                            normsOut.writeByte(fields3[minLoc].norms[uptos[minLoc]]);
                            int n = minLoc;
                            uptos[n] = uptos[n] + 1;
                            ++upto2;
                            if (uptos[minLoc] != fields3[minLoc].upto) continue;
                            fields3[minLoc].reset();
                            if (minLoc != numLeft - 1) {
                                fields3[minLoc] = fields3[numLeft - 1];
                                uptos[minLoc] = uptos[numLeft - 1];
                            }
                            --numLeft;
                        }
                        while (upto2 < state2.numDocs) {
                            normsOut.writeByte(this.defaultNorm);
                            ++upto2;
                        }
                    } else if (fieldInfo.isIndexed && !fieldInfo.omitNorms) {
                        ++normCount;
                        for (upto2 = 0; upto2 < state2.numDocs; ++upto2) {
                            normsOut.writeByte(this.defaultNorm);
                        }
                    }
                    assert (4L + (long)normCount * (long)state2.numDocs == normsOut.getFilePointer()) : ".nrm file size mismatch: expected=" + (4L + (long)normCount * (long)state2.numDocs) + " actual=" + normsOut.getFilePointer();
                }
                success2 = true;
                Object var22_25 = null;
                if (!success2) break block21;
            }
            catch (Throwable throwable) {
                Object var22_26 = null;
                if (success2) {
                    IOUtils.close(normsOut);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(normsOut);
                throw throwable;
            }
            IOUtils.close(normsOut);
            return;
        }
        IOUtils.closeWhileHandlingException(normsOut);
    }
}

