/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReader
extends IndexReader
implements Cloneable {
    protected final IndexReader[] subReaders;
    protected final int[] starts;
    private final boolean[] decrefOnClose;
    private final Map<String, byte[]> normsCache = new HashMap<String, byte[]>();
    private final int maxDoc;
    private int numDocs = -1;
    private boolean hasDeletions = false;

    public MultiReader(IndexReader ... subReaders) {
        this(subReaders, true);
    }

    public MultiReader(IndexReader[] subReaders, boolean closeSubReaders) {
        this((IndexReader[])subReaders.clone(), new boolean[subReaders.length]);
        for (int i2 = 0; i2 < subReaders.length; ++i2) {
            if (!closeSubReaders) {
                subReaders[i2].incRef();
                this.decrefOnClose[i2] = true;
                continue;
            }
            this.decrefOnClose[i2] = false;
        }
    }

    private MultiReader(IndexReader[] subReaders, boolean[] decrefOnClose) {
        this.subReaders = subReaders;
        this.decrefOnClose = decrefOnClose;
        this.starts = new int[subReaders.length + 1];
        int maxDoc = 0;
        for (int i2 = 0; i2 < subReaders.length; ++i2) {
            IndexReader reader = subReaders[i2];
            this.starts[i2] = maxDoc;
            maxDoc += reader.maxDoc();
            if (!reader.hasDeletions()) continue;
            this.hasDeletions = true;
        }
        int n = maxDoc;
        this.starts[subReaders.length] = n;
        this.maxDoc = n;
    }

    @Override
    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException("call getFieldInfos() on each sub reader, or use ReaderUtil.getMergedFieldInfos, instead");
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.doReopen(false);
    }

    @Override
    @Deprecated
    protected IndexReader doOpenIfChanged(boolean openReadOnly) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("MultiReader does not support reopening with changing readOnly flag. Use IndexReader.openIfChanged(IndexReader) instead.");
    }

    @Override
    public synchronized Object clone() {
        try {
            return this.doReopen(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @Deprecated
    public IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        throw new UnsupportedOperationException("MultiReader does not support cloning with changing readOnly flag. Use IndexReader.clone() instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private IndexReader doReopen(boolean doClone) throws CorruptIndexException, IOException {
        this.ensureOpen();
        changed = false;
        newSubReaders = new IndexReader[this.subReaders.length];
        success = false;
        try {
            for (i = 0; i < this.subReaders.length; ++i) {
                if (doClone) {
                    newSubReaders[i] = (IndexReader)this.subReaders[i].clone();
                    changed = true;
                    continue;
                }
                newSubReader = IndexReader.openIfChanged(this.subReaders[i]);
                if (newSubReader != null) {
                    newSubReaders[i] = newSubReader;
                    changed = true;
                    continue;
                }
                newSubReaders[i] = this.subReaders[i];
            }
            success = true;
            var8_9 = null;
            ** if (success || !changed) goto lbl-1000
        }
        catch (Throwable var7_15) {
            var8_10 = null;
            if (!success && changed) {
                for (i = 0; i < newSubReaders.length; ++i) {
                    if (newSubReaders[i] == this.subReaders[i]) continue;
                    try {
                        newSubReaders[i].close();
                        continue;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
            }
            throw var7_15;
        }
lbl-1000:
        // 4 sources

        {
            for (i = 0; i < newSubReaders.length; ++i) {
                if (newSubReaders[i] == this.subReaders[i]) continue;
                try {
                    newSubReaders[i].close();
                    continue;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (changed) {
            newDecrefOnClose = new boolean[this.subReaders.length];
            for (i = 0; i < this.subReaders.length; ++i) {
                if (newSubReaders[i] != this.subReaders[i]) continue;
                newSubReaders[i].incRef();
                newDecrefOnClose[i] = true;
            }
            return new MultiReader(newSubReaders, newDecrefOnClose);
        }
        return null;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].getTermFreqVectors(n - this.starts[i2]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field2) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].getTermFreqVector(n - this.starts[i2], field2);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field2, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(docNumber);
        this.subReaders[i2].getTermFreqVector(docNumber - this.starts[i2], field2, mapper);
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(docNumber);
        this.subReaders[i2].getTermFreqVector(docNumber - this.starts[i2], mapper);
    }

    @Override
    @Deprecated
    public boolean isOptimized() {
        this.ensureOpen();
        return false;
    }

    @Override
    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
                n += this.subReaders[i2].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].document(n - this.starts[i2], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].isDeleted(n - this.starts[i2]);
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.hasDeletions;
    }

    @Override
    @Deprecated
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i2 = this.readerIndex(n);
        this.subReaders[i2].deleteDocument(n - this.starts[i2]);
        this.hasDeletions = true;
    }

    @Override
    @Deprecated
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    protected int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    @Override
    public boolean hasNorms(String field2) throws IOException {
        this.ensureOpen();
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            if (!this.subReaders[i2].hasNorms(field2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized byte[] norms(String field2) throws IOException {
        this.ensureOpen();
        byte[] bytes2 = this.normsCache.get(field2);
        if (bytes2 != null) {
            return bytes2;
        }
        if (!this.hasNorms(field2)) {
            return null;
        }
        bytes2 = new byte[this.maxDoc()];
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].norms(field2, bytes2, this.starts[i2]);
        }
        this.normsCache.put(field2, bytes2);
        return bytes2;
    }

    @Override
    public synchronized void norms(String field2, byte[] result2, int offset2) throws IOException {
        int i2;
        this.ensureOpen();
        byte[] bytes2 = this.normsCache.get(field2);
        for (i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].norms(field2, result2, offset2 + this.starts[i2]);
        }
        if (bytes2 == null && !this.hasNorms(field2)) {
            Arrays.fill(result2, offset2, result2.length, Similarity.getDefault().encodeNormValue(1.0f));
        } else if (bytes2 != null) {
            System.arraycopy(bytes2, 0, result2, offset2, this.maxDoc());
        } else {
            for (i2 = 0; i2 < this.subReaders.length; ++i2) {
                this.subReaders[i2].norms(field2, result2, offset2 + this.starts[i2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    protected void doSetNorm(int n, String field2, byte value2) throws CorruptIndexException, IOException {
        Map<String, byte[]> map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(field2);
        }
        int i2 = this.readerIndex(n);
        this.subReaders[i2].setNorm(n - this.starts[i2], field2, value2);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms();
        }
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms(term);
        }
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total2 = 0;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            total2 += this.subReaders[i2].docFreq(t);
        }
        return total2;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs();
        }
        return new DirectoryReader.MultiTermDocs(this, this.subReaders, this.starts);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs(term);
        }
        return super.termDocs(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termPositions();
        }
        return new DirectoryReader.MultiTermPositions(this, this.subReaders, this.starts);
    }

    @Override
    @Deprecated
    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].commit(commitUserData);
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            try {
                if (this.decrefOnClose[i2]) {
                    this.subReaders[i2].decRef();
                    continue;
                }
                this.subReaders[i2].close();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            if (this.subReaders[i2].isCurrent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("MultiReader does not support this method.");
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }
}

