/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;

abstract class MultiLevelSkipListWriter {
    private int numberOfSkipLevels;
    private int skipInterval;
    private RAMOutputStream[] skipBuffer;

    protected MultiLevelSkipListWriter(int skipInterval, int maxSkipLevels, int df) {
        this.skipInterval = skipInterval;
        int n = this.numberOfSkipLevels = df == 0 ? 0 : (int)Math.floor(Math.log(df) / Math.log(skipInterval));
        if (this.numberOfSkipLevels > maxSkipLevels) {
            this.numberOfSkipLevels = maxSkipLevels;
        }
    }

    protected void init() {
        this.skipBuffer = new RAMOutputStream[this.numberOfSkipLevels];
        for (int i2 = 0; i2 < this.numberOfSkipLevels; ++i2) {
            this.skipBuffer[i2] = new RAMOutputStream();
        }
    }

    protected void resetSkip() {
        if (this.skipBuffer == null) {
            this.init();
        } else {
            for (int i2 = 0; i2 < this.skipBuffer.length; ++i2) {
                this.skipBuffer[i2].reset();
            }
        }
    }

    protected abstract void writeSkipData(int var1, IndexOutput var2) throws IOException;

    void bufferSkip(int df) throws IOException {
        int numLevels = 0;
        while (df % this.skipInterval == 0 && numLevels < this.numberOfSkipLevels) {
            ++numLevels;
            df /= this.skipInterval;
        }
        long childPointer = 0L;
        for (int level2 = 0; level2 < numLevels; ++level2) {
            this.writeSkipData(level2, this.skipBuffer[level2]);
            long newChildPointer = this.skipBuffer[level2].getFilePointer();
            if (level2 != 0) {
                this.skipBuffer[level2].writeVLong(childPointer);
            }
            childPointer = newChildPointer;
        }
    }

    long writeSkip(IndexOutput output) throws IOException {
        long skipPointer = output.getFilePointer();
        if (this.skipBuffer == null || this.skipBuffer.length == 0) {
            return skipPointer;
        }
        for (int level2 = this.numberOfSkipLevels - 1; level2 > 0; --level2) {
            long length2 = this.skipBuffer[level2].getFilePointer();
            if (length2 <= 0L) continue;
            output.writeVLong(length2);
            this.skipBuffer[level2].writeTo(output);
        }
        this.skipBuffer[0].writeTo(output);
        return skipPointer;
    }
}

