/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IndexInput;

abstract class MultiLevelSkipListReader {
    private int maxNumberOfSkipLevels;
    private int numberOfSkipLevels;
    private int numberOfLevelsToBuffer = 1;
    private int docCount;
    private boolean haveSkipped;
    private IndexInput[] skipStream;
    private long[] skipPointer;
    private int[] skipInterval;
    private int[] numSkipped;
    private int[] skipDoc;
    private int lastDoc;
    private long[] childPointer;
    private long lastChildPointer;
    private boolean inputIsBuffered;

    public MultiLevelSkipListReader(IndexInput skipStream, int maxSkipLevels, int skipInterval) {
        this.skipStream = new IndexInput[maxSkipLevels];
        this.skipPointer = new long[maxSkipLevels];
        this.childPointer = new long[maxSkipLevels];
        this.numSkipped = new int[maxSkipLevels];
        this.maxNumberOfSkipLevels = maxSkipLevels;
        this.skipInterval = new int[maxSkipLevels];
        this.skipStream[0] = skipStream;
        this.inputIsBuffered = skipStream instanceof BufferedIndexInput;
        this.skipInterval[0] = skipInterval;
        for (int i2 = 1; i2 < maxSkipLevels; ++i2) {
            this.skipInterval[i2] = this.skipInterval[i2 - 1] * skipInterval;
        }
        this.skipDoc = new int[maxSkipLevels];
    }

    int getDoc() {
        return this.lastDoc;
    }

    int skipTo(int target) throws IOException {
        int level2;
        if (!this.haveSkipped) {
            this.loadSkipLevels();
            this.haveSkipped = true;
        }
        for (level2 = 0; level2 < this.numberOfSkipLevels - 1 && target > this.skipDoc[level2 + 1]; ++level2) {
        }
        while (level2 >= 0) {
            if (target > this.skipDoc[level2]) {
                if (this.loadNextSkip(level2)) continue;
                continue;
            }
            if (level2 > 0 && this.lastChildPointer > this.skipStream[level2 - 1].getFilePointer()) {
                this.seekChild(level2 - 1);
            }
            --level2;
        }
        return this.numSkipped[0] - this.skipInterval[0] - 1;
    }

    private boolean loadNextSkip(int level2) throws IOException {
        this.setLastSkipData(level2);
        int n = level2;
        this.numSkipped[n] = this.numSkipped[n] + this.skipInterval[level2];
        if (this.numSkipped[level2] > this.docCount) {
            this.skipDoc[level2] = Integer.MAX_VALUE;
            if (this.numberOfSkipLevels > level2) {
                this.numberOfSkipLevels = level2;
            }
            return false;
        }
        int n2 = level2;
        this.skipDoc[n2] = this.skipDoc[n2] + this.readSkipData(level2, this.skipStream[level2]);
        if (level2 != 0) {
            this.childPointer[level2] = this.skipStream[level2].readVLong() + this.skipPointer[level2 - 1];
        }
        return true;
    }

    protected void seekChild(int level2) throws IOException {
        this.skipStream[level2].seek(this.lastChildPointer);
        this.numSkipped[level2] = this.numSkipped[level2 + 1] - this.skipInterval[level2 + 1];
        this.skipDoc[level2] = this.lastDoc;
        if (level2 > 0) {
            this.childPointer[level2] = this.skipStream[level2].readVLong() + this.skipPointer[level2 - 1];
        }
    }

    void close() throws IOException {
        for (int i2 = 1; i2 < this.skipStream.length; ++i2) {
            if (this.skipStream[i2] == null) continue;
            this.skipStream[i2].close();
        }
    }

    void init(long skipPointer, int df) {
        this.skipPointer[0] = skipPointer;
        this.docCount = df;
        Arrays.fill(this.skipDoc, 0);
        Arrays.fill(this.numSkipped, 0);
        Arrays.fill(this.childPointer, 0L);
        this.haveSkipped = false;
        for (int i2 = 1; i2 < this.numberOfSkipLevels; ++i2) {
            this.skipStream[i2] = null;
        }
    }

    private void loadSkipLevels() throws IOException {
        int n = this.numberOfSkipLevels = this.docCount == 0 ? 0 : (int)Math.floor(Math.log(this.docCount) / Math.log(this.skipInterval[0]));
        if (this.numberOfSkipLevels > this.maxNumberOfSkipLevels) {
            this.numberOfSkipLevels = this.maxNumberOfSkipLevels;
        }
        this.skipStream[0].seek(this.skipPointer[0]);
        int toBuffer = this.numberOfLevelsToBuffer;
        for (int i2 = this.numberOfSkipLevels - 1; i2 > 0; --i2) {
            long length2 = this.skipStream[0].readVLong();
            this.skipPointer[i2] = this.skipStream[0].getFilePointer();
            if (toBuffer > 0) {
                this.skipStream[i2] = new SkipBuffer(this.skipStream[0], (int)length2);
                --toBuffer;
                continue;
            }
            this.skipStream[i2] = (IndexInput)this.skipStream[0].clone();
            if (this.inputIsBuffered && length2 < 1024L) {
                ((BufferedIndexInput)this.skipStream[i2]).setBufferSize((int)length2);
            }
            this.skipStream[0].seek(this.skipStream[0].getFilePointer() + length2);
        }
        this.skipPointer[0] = this.skipStream[0].getFilePointer();
    }

    protected abstract int readSkipData(int var1, IndexInput var2) throws IOException;

    protected void setLastSkipData(int level2) {
        this.lastDoc = this.skipDoc[level2];
        this.lastChildPointer = this.childPointer[level2];
    }

    private static final class SkipBuffer
    extends IndexInput {
        private byte[] data;
        private long pointer;
        private int pos;

        SkipBuffer(IndexInput input, int length2) throws IOException {
            super("SkipBuffer on " + input);
            this.data = new byte[length2];
            this.pointer = input.getFilePointer();
            input.readBytes(this.data, 0, length2);
        }

        public void close() throws IOException {
            this.data = null;
        }

        public long getFilePointer() {
            return this.pointer + (long)this.pos;
        }

        public long length() {
            return this.data.length;
        }

        public byte readByte() throws IOException {
            return this.data[this.pos++];
        }

        public void readBytes(byte[] b, int offset2, int len) throws IOException {
            System.arraycopy(this.data, this.pos, b, offset2, len);
            this.pos += len;
        }

        public void seek(long pos2) throws IOException {
            this.pos = (int)(pos2 - this.pointer);
        }
    }
}

