/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import org.apache.lucene.index.IndexFileNames;

public class IndexFileNameFilter
implements FilenameFilter {
    private static IndexFileNameFilter singleton = new IndexFileNameFilter();
    private HashSet<String> extensions = new HashSet();
    private HashSet<String> extensionsInCFS;

    private IndexFileNameFilter() {
        for (String ext2 : IndexFileNames.INDEX_EXTENSIONS) {
            this.extensions.add(ext2);
        }
        this.extensionsInCFS = new HashSet();
        for (String ext2 : IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE) {
            this.extensionsInCFS.add(ext2);
        }
    }

    public boolean accept(File dir, String name2) {
        int i2 = name2.lastIndexOf(46);
        if (i2 != -1) {
            String extension = name2.substring(1 + i2);
            if (this.extensions.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && extension.matches("f\\d+")) {
                return true;
            }
            if (extension.startsWith("s") && extension.matches("s\\d+")) {
                return true;
            }
        } else {
            if (name2.equals("deletable")) {
                return true;
            }
            if (name2.startsWith("segments")) {
                return true;
            }
        }
        return false;
    }

    public boolean isCFSFile(String name2) {
        int i2 = name2.lastIndexOf(46);
        if (i2 != -1) {
            String extension = name2.substring(1 + i2);
            if (this.extensionsInCFS.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && extension.matches("f\\d+")) {
                return true;
            }
        }
        return false;
    }

    public static IndexFileNameFilter getFilter() {
        return singleton;
    }
}

