/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FormatPostingsDocsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsWriter;
import org.apache.lucene.index.FormatPostingsPositionsConsumer;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.FreqProxFieldMergeState;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.FreqProxTermsWriterPerThread;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.UnicodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FreqProxTermsWriter
extends TermsHashConsumer {
    private byte[] payloadBuffer;
    final UnicodeUtil.UTF8Result termsUTF8 = new UnicodeUtil.UTF8Result();

    FreqProxTermsWriter() {
    }

    @Override
    public TermsHashConsumerPerThread addThread(TermsHashPerThread perThread) {
        return new FreqProxTermsWriterPerThread(perThread);
    }

    private static int compareText(char[] text1, int pos1, char[] text2, int pos2) {
        char c1;
        do {
            char c2;
            if ((c1 = text1[pos1++]) == (c2 = text2[pos2++])) continue;
            if ('\uffff' == c2) {
                return 1;
            }
            if ('\uffff' == c1) {
                return -1;
            }
            return c1 - c2;
        } while ('\uffff' != c1);
        return 0;
    }

    @Override
    void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> threadsAndFields, SegmentWriteState state2) throws IOException {
        ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
        for (Map.Entry<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> entry : threadsAndFields.entrySet()) {
            Collection<TermsHashConsumerPerField> fields2 = entry.getValue();
            for (TermsHashConsumerPerField termsHashConsumerPerField : fields2) {
                FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)termsHashConsumerPerField;
                if (perField.termsHashPerField.numPostings <= 0) continue;
                allFields.add(perField);
            }
        }
        CollectionUtil.quickSort(allFields);
        int numAllFields = allFields.size();
        FormatPostingsFieldsWriter consumer = new FormatPostingsFieldsWriter(state2, this.fieldInfos);
        try {
            int start2 = 0;
            while (start2 < numAllFields) {
                int end2;
                FieldInfo fieldInfo = ((FreqProxTermsWriterPerField)allFields.get((int)start2)).fieldInfo;
                String string2 = fieldInfo.name;
                for (end2 = start2 + 1; end2 < numAllFields && ((FreqProxTermsWriterPerField)allFields.get((int)end2)).fieldInfo.name.equals(string2); ++end2) {
                }
                FreqProxTermsWriterPerField[] fields3 = new FreqProxTermsWriterPerField[end2 - start2];
                for (int i3 = start2; i3 < end2; ++i3) {
                    fields3[i3 - start2] = (FreqProxTermsWriterPerField)allFields.get(i3);
                    if (fieldInfo.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) continue;
                    fieldInfo.storePayloads |= fields3[i3 - start2].hasPayloads;
                }
                this.appendPostings(string2, state2, fields3, consumer);
                for (int i2 = 0; i2 < fields3.length; ++i2) {
                    TermsHashPerField perField = fields3[i2].termsHashPerField;
                    int numPostings = perField.numPostings;
                    perField.reset();
                    perField.shrinkHash(numPostings);
                    fields3[i2].reset();
                }
                start2 = end2;
            }
            for (Map.Entry entry : threadsAndFields.entrySet()) {
                FreqProxTermsWriterPerThread perThread = (FreqProxTermsWriterPerThread)entry.getKey();
                perThread.termsHashPerThread.reset(true);
            }
            Object var15_22 = null;
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            ((FormatPostingsFieldsConsumer)consumer).finish();
            throw throwable;
        }
        ((FormatPostingsFieldsConsumer)consumer).finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendPostings(String fieldName, SegmentWriteState state2, FreqProxTermsWriterPerField[] fields2, FormatPostingsFieldsConsumer consumer) throws CorruptIndexException, IOException {
        int numFields = fields2.length;
        FreqProxFieldMergeState[] mergeStates = new FreqProxFieldMergeState[numFields];
        for (int i2 = 0; i2 < numFields; ++i2) {
            FreqProxFieldMergeState fms = mergeStates[i2] = new FreqProxFieldMergeState(fields2[i2]);
            assert (fms.field.fieldInfo == fields2[0].fieldInfo);
            boolean result2 = fms.nextTerm();
            assert (result2);
        }
        FormatPostingsTermsConsumer termsConsumer = consumer.addField(fields2[0].fieldInfo);
        Term protoTerm = new Term(fieldName);
        FreqProxFieldMergeState[] termStates = new FreqProxFieldMergeState[numFields];
        FieldInfo.IndexOptions currentFieldIndexOptions = fields2[0].fieldInfo.indexOptions;
        Map<Term, Integer> segDeletes = state2.segDeletes != null && state2.segDeletes.terms.size() > 0 ? state2.segDeletes.terms : null;
        try {
            while (numFields > 0) {
                Object var26_30;
                Integer docIDUpto;
                termStates[0] = mergeStates[0];
                int numToMerge = 1;
                for (int i3 = 1; i3 < numFields; ++i3) {
                    char[] text = mergeStates[i3].text;
                    int textOffset = mergeStates[i3].textOffset;
                    int cmp2 = FreqProxTermsWriter.compareText(text, textOffset, termStates[0].text, termStates[0].textOffset);
                    if (cmp2 < 0) {
                        termStates[0] = mergeStates[i3];
                        numToMerge = 1;
                        continue;
                    }
                    if (cmp2 != 0) continue;
                    termStates[numToMerge++] = mergeStates[i3];
                }
                FormatPostingsDocsConsumer docConsumer = termsConsumer.addTerm(termStates[0].text, termStates[0].textOffset);
                int delDocLimit = segDeletes != null ? ((docIDUpto = segDeletes.get(protoTerm.createTerm(termStates[0].termText()))) != null ? docIDUpto : 0) : 0;
                try {
                    while (numToMerge > 0) {
                        int i4;
                        FreqProxFieldMergeState minState = termStates[0];
                        for (int i5 = 1; i5 < numToMerge; ++i5) {
                            if (termStates[i5].docID >= minState.docID) continue;
                            minState = termStates[i5];
                        }
                        int termDocFreq = minState.termFreq;
                        FormatPostingsPositionsConsumer posConsumer = docConsumer.addDoc(minState.docID, termDocFreq);
                        if (minState.docID < delDocLimit) {
                            if (state2.deletedDocs == null) {
                                state2.deletedDocs = new BitVector(state2.numDocs);
                            }
                            state2.deletedDocs.set(minState.docID);
                        }
                        ByteSliceReader prox = minState.prox;
                        if (currentFieldIndexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                            Object var24_29;
                            try {
                                int position = 0;
                                for (int j = 0; j < termDocFreq; ++j) {
                                    int payloadLength;
                                    int code = prox.readVInt();
                                    position += code >>> 1;
                                    if ((code & 1) != 0) {
                                        payloadLength = prox.readVInt();
                                        if (this.payloadBuffer == null || this.payloadBuffer.length < payloadLength) {
                                            this.payloadBuffer = new byte[payloadLength];
                                        }
                                        prox.readBytes(this.payloadBuffer, 0, payloadLength);
                                    } else {
                                        payloadLength = 0;
                                    }
                                    posConsumer.addPosition(position, this.payloadBuffer, 0, payloadLength);
                                }
                                var24_29 = null;
                            }
                            catch (Throwable throwable) {
                                var24_29 = null;
                                posConsumer.finish();
                                throw throwable;
                            }
                            posConsumer.finish();
                            {
                            }
                        }
                        if (minState.nextDoc()) continue;
                        int upto2 = 0;
                        for (i4 = 0; i4 < numToMerge; ++i4) {
                            if (termStates[i4] == minState) continue;
                            termStates[upto2++] = termStates[i4];
                        }
                        assert (upto2 == --numToMerge);
                        if (minState.nextTerm()) continue;
                        upto2 = 0;
                        for (i4 = 0; i4 < numFields; ++i4) {
                            if (mergeStates[i4] == minState) continue;
                            mergeStates[upto2++] = mergeStates[i4];
                        }
                        assert (upto2 == --numFields);
                    }
                    var26_30 = null;
                }
                catch (Throwable throwable) {
                    var26_30 = null;
                    docConsumer.finish();
                    throw throwable;
                }
                docConsumer.finish();
                {
                }
            }
            Object var28_33 = null;
        }
        catch (Throwable throwable) {
            Object var28_34 = null;
            termsConsumer.finish();
            throw throwable;
        }
        termsConsumer.finish();
    }
}

